@echo off
REM ===============================
REM Schedule applicare_collector.exe at system startup
REM Schedule stop_collector.bat separately
REM ===============================

REM ==== Configuration ====
set "TASK_FOLDER=\ApplicareCollector"

REM Collector task
set "COLLECTOR_TASK_NAME=start_Collector"
set "COLLECTOR_EXE=%~dp0applicare_collector.exe"
set "COLLECTOR_FULL_TASK=%TASK_FOLDER%\%COLLECTOR_TASK_NAME%"

REM StopCollector task
set "STOP_TASK_NAME=StopCollector"
set "STOP_SCRIPT=%~dp0stop_collector.bat"
set "STOP_FULL_TASK=%TASK_FOLDER%\%STOP_TASK_NAME%"

REM ==== Validate files ====
if not exist "%COLLECTOR_EXE%" (
    echo ERROR: applicare_collector.exe not found at: %COLLECTOR_EXE%
    pause
    exit /b 1
)
if not exist "%STOP_SCRIPT%" (
    echo ERROR: stop_collector.bat not found at: %STOP_SCRIPT%
    pause
    exit /b 1
)

REM ==== Delete existing Collector task ====
schtasks /query /tn "%COLLECTOR_FULL_TASK%" >nul 2>&1
if %errorlevel%==0 (
    echo Deleting existing task "%COLLECTOR_FULL_TASK%"...
    schtasks /delete /tn "%COLLECTOR_FULL_TASK%" /f >nul
)

REM ==== Create new Collector task ====
echo Creating task "%COLLECTOR_FULL_TASK%"...
schtasks /create ^
  /tn "%COLLECTOR_FULL_TASK%" ^
  /sc onstart ^
  /rl highest ^
  /ru "SYSTEM" ^
  /tr "\"%COLLECTOR_EXE%\"" ^
  /f

if %errorlevel%==0 (
    echo SUCCESS: "%COLLECTOR_FULL_TASK%" created.
    echo Starting collector...
    schtasks /run /tn "%COLLECTOR_FULL_TASK%"
) else (
    echo ERROR: Failed to create collector task.
)

REM ==== Delete existing StopCollector task ====
schtasks /query /tn "%STOP_FULL_TASK%" >nul 2>&1
if %errorlevel%==0 (
    echo Deleting existing task "%STOP_FULL_TASK%"...
    schtasks /delete /tn "%STOP_FULL_TASK%" /f >nul
)

REM ==== Create new StopCollector task ====
echo Creating task "%STOP_FULL_TASK%"...
schtasks /create ^
  /tn "%STOP_FULL_TASK%" ^
  /sc onlogon ^
  /rl highest ^
  /ru "SYSTEM" ^
  /tr "\"%STOP_SCRIPT%\"" ^
  /f

if %errorlevel%==0 (
    echo SUCCESS: "%STOP_FULL_TASK%" created.
) else (
    echo ERROR: Failed to create stop collector task.
)

