@echo off
REM ===============================
REM Schedule elasticsearch.bat at system startup
REM And configure stop_elasticsearch.bat task (not started immediately)
REM ===============================

REM ==== Configuration ====
set "TASK_FOLDER=\ApplicareCollector"

REM Start Elasticsearch Task
set "START_TASK_NAME=startelasticsearch"
set "START_BAT=%~dp0\elasticsearch\bin\elasticsearch.bat"
set "START_TASK_FULL=%TASK_FOLDER%\%START_TASK_NAME%"

REM Stop Elasticsearch Task
set "STOP_TASK_NAME=stopelasticsearch"
set "STOP_BAT=%~dp0stop_elasticsearch.bat"
set "STOP_TASK_FULL=%TASK_FOLDER%\%STOP_TASK_NAME%"

REM ==== Validate Files ====
if not exist "%START_BAT%" (
    echo ERROR: elasticsearch.bat not found at: %START_BAT%
    pause
    exit /b 1
)

if not exist "%STOP_BAT%" (
    echo ERROR: stop_elasticsearch.bat not found at: %STOP_BAT%
    pause
    exit /b 1
)



REM ==== Create Start Elasticsearch Task ====
echo Creating task "%START_TASK_FULL%"...
schtasks /create ^
  /tn "%START_TASK_FULL%" ^
  /sc onstart ^
  /rl highest ^
  /ru "SYSTEM" ^
  /tr "\"%START_BAT%\"" ^
  /f

if %errorlevel%==0 (
    echo SUCCESS: "%START_TASK_FULL%" created.
    echo Starting Elasticsearch task...
    schtasks /run /tn "%START_TASK_FULL%"
) else (
    echo ERROR: Failed to create "%START_TASK_FULL%".
)

REM ==== Create Stop Elasticsearch Task (Manual Trigger) ====
echo Creating task "%STOP_TASK_FULL%"...
schtasks /create ^
  /tn "%STOP_TASK_FULL%" ^
  /sc onstart ^
  /rl highest ^
  /ru "SYSTEM" ^
  /tr "\"%STOP_BAT%\"" ^
  /f

if %errorlevel%==0 (
    echo SUCCESS: "%STOP_TASK_FULL%" created.
    echo NOTE: This task will not run now. You must run it manually when needed.
) else (
    echo ERROR: Failed to create "%STOP_TASK_FULL%".
)
