@echo off
SETLOCAL ENABLEEXTENSIONS
REM ===============================
REM Schedule applicare_collector.exe at system startup
REM Schedule stop_collector.bat separately
REM ===============================

REM Set environment variable related to Elasticsearch
setx SPAN_STORAGE_TYPE "elasticsearch" /M
IF %ERRORLEVEL%==0 (
    echo Successfully set SPAN_STORAGE_TYPE to "elasticsearch"
) ELSE (
    echo Failed to set SPAN_STORAGE_TYPE
)

setx ES_SERVER_URLS "http://localhost:9200" /M
IF %ERRORLEVEL%==0 (
    echo Successfully set ES_SERVER_URLS to "http://localhost:9200"
) ELSE (
    echo Failed to set ES_SERVER_URLS
)


REM call Elasticsearch task create bat file
call create_elasticsearch_task.bat


REM ==== Configuration ====
set "TASK_FOLDER=\ApplicareCollector"

REM Collector task
set "COLLECTOR_TASK_NAME=applicare-collector"
set "COLLECTOR_EXE=%~dp0applicare-collector.exe"
set "COLLECTOR_FULL_TASK=%TASK_FOLDER%\%COLLECTOR_TASK_NAME%"

REM Query task
set "QUERY_TASK_NAME=applicare-query"
set "QUERY_EXE=%~dp0applicare-query.exe"
set "QUERY_FULL_TASK=%TASK_FOLDER%\%QUERY_TASK_NAME%"

REM StopCollector task
set "STOP_TASK_NAME=stopcollector"
set "STOP_SCRIPT=%~dp0stop_collector.bat"
set "STOP_FULL_TASK=%TASK_FOLDER%\%STOP_TASK_NAME%"

REM ==== Validate files ====
if not exist "%COLLECTOR_EXE%" (
    echo ERROR: applicare-collector.exe not found at: %COLLECTOR_EXE%
    pause
    exit /b 1
)
if not exist "%STOP_SCRIPT%" (
    echo ERROR: stop_collector.bat not found at: %STOP_SCRIPT%
    pause
    exit /b 1
)


REM ==== Create new Collector task ====
echo Creating task "%COLLECTOR_FULL_TASK%"...
schtasks /create ^
  /tn "%COLLECTOR_FULL_TASK%" ^
  /sc onstart ^
  /rl highest ^
  /ru "SYSTEM" ^
  /tr "\"%COLLECTOR_EXE%\"" ^
  /f

REM ==== Create new applicare_query task ====
echo Creating task "%QUERY_FULL_TASK%"...
schtasks /create ^
  /tn "%QUERY_FULL_TASK%" ^
  /sc onstart ^
  /rl highest ^
  /ru "SYSTEM" ^
  /tr "\"%QUERY_EXE%\"" ^
  /f

echo
echo
echo



echo "It will take 120 seconds for Elasticsearch to start completely. Please wait 120 seconds."
timeout /t 120


if %errorlevel%==0 (
    echo SUCCESS: "%COLLECTOR_FULL_TASK%" created.
    echo Starting collector...
    schtasks /run /tn "%COLLECTOR_FULL_TASK%"
) else (
    echo ERROR: Failed to create collector task.
)

if %errorlevel%==0 (
    echo SUCCESS: "%QUERY_FULL_TASK%" created.
    echo Starting collector...
    schtasks /run /tn "%QUERY_FULL_TASK%"
) else (
    echo ERROR: Failed to create collector task.
)


REM ==== Create new StopCollector task ====
echo Creating task "%STOP_FULL_TASK%"...
schtasks /create ^
  /tn "%STOP_FULL_TASK%" ^
  /sc onlogon ^
  /rl highest ^
  /ru "SYSTEM" ^
  /tr "\"%STOP_SCRIPT%\"" ^
  /f

if %errorlevel%==0 (
    echo SUCCESS: "%STOP_FULL_TASK%" created.
) else (
    echo ERROR: Failed to create stop collector task.
)

