@echo off
SETLOCAL ENABLEEXTENSIONS

REM ===============================
REM Applicare Metric Collector Task Setup
REM ===============================

set "TASK_FOLDER=\ApplicareCollector"
set "BASE_DIR=%~dp0" 

REM StartCollector task
set "START_TASK=start_metric_collector"
set "START_SCRIPT=%~dp0start_metric_collector.bat"
set "START_FULL_TASK=%TASK_FOLDER%\%START_TASK%"

REM StopCollector task
set "STOP_TASK_NAME=stop_metric_collector"
set "STOP_SCRIPT=%~dp0stop_metrics_collector.bat"
set "STOP_FULL_TASK=%TASK_FOLDER%\%STOP_TASK_NAME%"

REM ==== Create Start Task ====
schtasks /query /tn "%START_FULL_TASK%" >nul 2>&1
if %errorlevel%==0 (
    echo Task "%START_FULL_TASK%" already exists. Skipping creation.
) else (
    echo Creating task "%START_FULL_TASK%"...
    schtasks /create ^
      /tn "%START_FULL_TASK%" ^
      /sc onstart ^
      /rl HIGHEST ^
      /ru SYSTEM ^
      /tr "\"%START_SCRIPT%\"" ^
      /f
)

if %errorlevel%==0 (
    echo SUCCESS: "%START_FULL_TASK%" created.
    echo Starting metric collector...
    schtasks /run /tn "%START_FULL_TASK%" >nul 2>&1
) else (
    echo ERROR: Failed to create Metrics collector task.
)

REM ==== Create new StopCollector task ====
echo Creating task "%STOP_FULL_TASK%"...
schtasks /create ^
  /tn "%STOP_FULL_TASK%" ^
  /sc onlogon ^
  /rl HIGHEST ^
  /ru SYSTEM ^
  /tr "\"%STOP_SCRIPT%\"" ^
  /f

if %errorlevel%==0 (
    echo SUCCESS: "%STOP_FULL_TASK%" created.
) else (
    echo ERROR: Failed to create stop collector task.
)

echo.
echo Task created successfully!:

ENDLOCAL
