@echo off
SETLOCAL ENABLEEXTENSIONS

REM ===============================
REM Applicare Log Collector Task Setup
REM ===============================

set "TASK_FOLDER=\ApplicareCollector"
set "BASE_DIR=%~dp0" 

REM Paths
set "COLLECTOR_EXE=%BASE_DIR%applicare_log_collector.exe"
set "CONFIG_FILE=%BASE_DIR%applicare-logcollector-config.yaml"
set "START_SCRIPT=%BASE_DIR%start_log_collector.bat"
set "STOP_SCRIPT=%BASE_DIR%stop_log_collector.bat"

REM Task names
set "START_TASK=%TASK_FOLDER%\start_log_collector"
set "STOP_TASK=%TASK_FOLDER%\stop_log_collector"

REM ==== Validate files ====
if not exist "%COLLECTOR_EXE%" (
    echo ERROR: applicare_log_collector.exe not found at %COLLECTOR_EXE%
    exit /b 1
)
if not exist "%CONFIG_FILE%" (
    echo ERROR: Config file not found at %CONFIG_FILE%
    exit /b 1
)
if not exist "%START_SCRIPT%" (
    echo ERROR: start_log_collector.bat not found at %START_SCRIPT%
    exit /b 1
)
if not exist "%STOP_SCRIPT%" (
    echo ERROR: stop_log_collector.bat not found at %STOP_SCRIPT%
    exit /b 1
)

REM ==== Create Start Task ====
schtasks /query /tn "%START_TASK%" >nul 2>&1
if %errorlevel%==0 (
    echo Task "%START_TASK%" already exists. Skipping creation.
) else (
    echo Creating task "%START_TASK%"...
    schtasks /create ^
      /tn "%START_TASK%" ^
      /sc onstart ^
      /rl HIGHEST ^
      /ru SYSTEM ^
      /tr "\"%START_SCRIPT%\"" ^
      /f
)

if %errorlevel%==0 (
    echo SUCCESS: "%START_TASK%" created.
    echo Starting log collector...
    schtasks /run /tn "%START_TASK%"
) else (
    echo ERROR: Failed to create Log collector task.
)

REM ==== Create Stop Task ====
schtasks /query /tn "%STOP_TASK%" >nul 2>&1
if %errorlevel%==0 (
    echo Task "%STOP_TASK%" already exists. Skipping creation.
) else (
    echo Creating task "%STOP_TASK%"...
    schtasks /create ^
      /tn "%STOP_TASK%" ^
      /sc onlogon ^
      /rl HIGHEST ^
      /ru SYSTEM ^
      /tr "\"%STOP_SCRIPT%\"" ^
      /f
)

if %errorlevel%==0 (
    echo SUCCESS: "%STOP_TASK%" created.
) else (
    echo ERROR: Failed to create stop collector task.
)

echo.
echo Task creation process completed!
ENDLOCAL
