/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.bucket.adjacency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.aggregations.bucket.adjacency.AdjacencyMatrix;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.ObjectObjectPagedHashMap;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.BucketReducer;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalAdjacencyMatrix
extends InternalMultiBucketAggregation<InternalAdjacencyMatrix, InternalBucket>
implements AdjacencyMatrix {
    private final List<InternalBucket> buckets;
    private Map<String, InternalBucket> bucketMap;

    public InternalAdjacencyMatrix(String name, List<InternalBucket> buckets, Map<String, Object> metadata) {
        super(name, metadata);
        this.buckets = buckets;
    }

    public InternalAdjacencyMatrix(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        ArrayList<InternalBucket> buckets = new ArrayList<InternalBucket>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(new InternalBucket(in));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeCollection(this.buckets);
    }

    public String getWriteableName() {
        return "adjacency_matrix";
    }

    public InternalAdjacencyMatrix create(List<InternalBucket> buckets) {
        return new InternalAdjacencyMatrix(this.name, buckets, this.metadata);
    }

    public InternalBucket createBucket(InternalAggregations aggregations, InternalBucket prototype) {
        return new InternalBucket(prototype.key, prototype.docCount, aggregations);
    }

    public List<InternalBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public InternalBucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = Maps.newMapWithExpectedSize((int)this.buckets.size());
            for (InternalBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            final ObjectObjectPagedHashMap<String, BucketReducer<InternalBucket>> bucketsReducer;
            {
                this.bucketsReducer = new ObjectObjectPagedHashMap((long)InternalAdjacencyMatrix.this.getBuckets().size(), reduceContext.bigArrays());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(InternalAggregation aggregation) {
                InternalAdjacencyMatrix filters = (InternalAdjacencyMatrix)aggregation;
                for (InternalBucket bucket : filters.buckets) {
                    BucketReducer reducer = (BucketReducer)this.bucketsReducer.get((Object)bucket.key);
                    if (reducer == null) {
                        reducer = new BucketReducer((MultiBucketsAggregation.Bucket)bucket, reduceContext, size);
                        boolean success = false;
                        try {
                            this.bucketsReducer.put((Object)bucket.key, (Object)reducer);
                            success = true;
                        }
                        finally {
                            if (!success) {
                                Releasables.close((Releasable)reducer);
                            }
                        }
                    }
                    reducer.accept((MultiBucketsAggregation.Bucket)bucket);
                }
            }

            public InternalAggregation get() {
                ArrayList<InternalBucket> reducedBuckets = new ArrayList<InternalBucket>((int)this.bucketsReducer.size());
                this.bucketsReducer.forEach(entry -> {
                    if (((BucketReducer)entry.value).getDocCount() >= 1L) {
                        reducedBuckets.add(new InternalBucket((String)entry.key, ((BucketReducer)entry.value).getDocCount(), ((BucketReducer)entry.value).getAggregations()));
                    }
                });
                reduceContext.consumeBucketsAndMaybeBreak(reducedBuckets.size());
                reducedBuckets.sort(Comparator.comparing(InternalBucket::getKey));
                return new InternalAdjacencyMatrix(InternalAdjacencyMatrix.this.name, reducedBuckets, InternalAdjacencyMatrix.this.getMetadata());
            }

            public void close() {
                this.bucketsReducer.forEach(entry -> Releasables.close((Releasable)((Releasable)entry.value)));
                Releasables.close(this.bucketsReducer);
            }
        };
    }

    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return new InternalAdjacencyMatrix(this.name, this.buckets.stream().map(b -> b.finalizeSampling(samplingContext)).toList(), this.getMetadata());
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (InternalBucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalAdjacencyMatrix that = (InternalAdjacencyMatrix)obj;
        return Objects.equals(this.buckets, that.buckets);
    }

    public static class InternalBucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements AdjacencyMatrix.Bucket {
        private final String key;
        private long docCount;
        InternalAggregations aggregations;

        public InternalBucket(String key, long docCount, InternalAggregations aggregations) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        public InternalBucket(StreamInput in) throws IOException {
            this.key = in.readOptionalString();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        public String getKey() {
            return this.key;
        }

        public String getKeyAsString() {
            return this.key;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public InternalAggregations getAggregations() {
            return this.aggregations;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            InternalBucket that = (InternalBucket)other;
            return Objects.equals(this.key, that.key) && Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key, this.docCount, this.aggregations);
        }

        InternalBucket finalizeSampling(SamplingContext samplingContext) {
            return new InternalBucket(this.key, samplingContext.scaleUp(this.docCount), InternalAggregations.finalizeSampling((InternalAggregations)this.aggregations, (SamplingContext)samplingContext));
        }
    }
}

