/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckAction;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckResponse;

public class DeprecationInfoAction
extends ActionType<Response> {
    public static final DeprecationInfoAction INSTANCE = new DeprecationInfoAction();
    public static final String NAME = "cluster:admin/xpack/deprecation/info";

    private DeprecationInfoAction() {
        super(NAME);
    }

    public static <T> List<DeprecationIssue> filterChecks(List<T> checks, Function<T, DeprecationIssue> mapper) {
        return checks.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<DeprecationIssue> mergeNodeIssues(NodesDeprecationCheckResponse response) {
        Collection<List<Tuple<DeprecationIssue, String>>> issuesToMerge = DeprecationInfoAction.getDeprecationIssuesThatDifferOnlyByMeta(response.getNodes());
        Map<DeprecationIssue, List<String>> issueToListOfNodesMap = DeprecationInfoAction.getMergedIssuesToNodesMap(issuesToMerge);
        return issueToListOfNodesMap.entrySet().stream().map(entry -> {
            DeprecationIssue issue = (DeprecationIssue)entry.getKey();
            String details = issue.getDetails() != null ? issue.getDetails() + " " : "";
            return new DeprecationIssue(issue.getLevel(), issue.getMessage(), issue.getUrl(), details + "(nodes impacted: " + entry.getValue() + ")", issue.isResolveDuringRollingUpgrade(), issue.getMeta());
        }).collect(Collectors.toList());
    }

    private static Collection<List<Tuple<DeprecationIssue, String>>> getDeprecationIssuesThatDifferOnlyByMeta(List<NodesDeprecationCheckAction.NodeResponse> nodeResponses) {
        HashMap<DeprecationIssue, List> issuesToMerge = new HashMap<DeprecationIssue, List>();
        for (NodesDeprecationCheckAction.NodeResponse resp : nodeResponses) {
            for (DeprecationIssue issue : resp.getDeprecationIssues()) {
                issuesToMerge.computeIfAbsent(new DeprecationIssue(issue.getLevel(), issue.getMessage(), issue.getUrl(), issue.getDetails(), issue.isResolveDuringRollingUpgrade(), null), key -> new ArrayList()).add(new Tuple((Object)issue, (Object)resp.getNode().getName()));
            }
        }
        return issuesToMerge.values();
    }

    private static Map<DeprecationIssue, List<String>> getMergedIssuesToNodesMap(Collection<List<Tuple<DeprecationIssue, String>>> issuesToMerge) {
        HashMap<DeprecationIssue, List<String>> issueToListOfNodesMap = new HashMap<DeprecationIssue, List<String>>();
        for (List<Tuple<DeprecationIssue, String>> similarIssues : issuesToMerge) {
            DeprecationIssue leastCommonDenominator = DeprecationIssue.getIntersectionOfRemovableSettings(similarIssues.stream().map(Tuple::v1).toList());
            issueToListOfNodesMap.computeIfAbsent(leastCommonDenominator, key -> new ArrayList()).addAll(similarIssues.stream().map(Tuple::v2).toList());
        }
        return issueToListOfNodesMap;
    }

    private static ClusterState removeSkippedSettings(ClusterState state, String[] indexNames, List<String> skipTheseDeprecatedSettings) {
        ClusterState.Builder clusterStateBuilder = new ClusterState.Builder(state);
        Metadata.Builder metadataBuilder = Metadata.builder((Metadata)state.metadata());
        metadataBuilder.transientSettings(metadataBuilder.transientSettings().filter(setting -> !Regex.simpleMatch((List)skipTheseDeprecatedSettings, (String)setting)));
        metadataBuilder.persistentSettings(metadataBuilder.persistentSettings().filter(setting -> !Regex.simpleMatch((List)skipTheseDeprecatedSettings, (String)setting)));
        HashMap<String, IndexMetadata> indicesBuilder = new HashMap<String, IndexMetadata>(state.getMetadata().indices());
        for (String indexName : indexNames) {
            IndexMetadata indexMetadata = state.getMetadata().index(indexName);
            IndexMetadata.Builder filteredIndexMetadataBuilder = new IndexMetadata.Builder(indexMetadata);
            Settings filteredSettings = indexMetadata.getSettings().filter(setting -> !Regex.simpleMatch((List)skipTheseDeprecatedSettings, (String)setting));
            filteredIndexMetadataBuilder.settings(filteredSettings);
            indicesBuilder.put(indexName, filteredIndexMetadataBuilder.build());
        }
        metadataBuilder.indices(indicesBuilder);
        clusterStateBuilder.metadata(metadataBuilder);
        return clusterStateBuilder.build();
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private static final IndicesOptions INDICES_OPTIONS = IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true);
        private String[] indices;

        public Request(String ... indices) {
            this.indices = indices;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.indices = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.indices);
        }

        public String[] indices() {
            return this.indices;
        }

        public Request indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public IndicesOptions indicesOptions() {
            return INDICES_OPTIONS;
        }

        public boolean includeDataStreams() {
            return true;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indices == null) {
                validationException = ValidateActions.addValidationError((String)"index/indices is missing", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.indices, request.indices);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices));
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        static final Set<String> RESERVED_NAMES = Set.of("cluster_settings", "node_settings", "index_settings");
        private final List<DeprecationIssue> clusterSettingsIssues;
        private final List<DeprecationIssue> nodeSettingsIssues;
        private final Map<String, List<DeprecationIssue>> indexSettingsIssues;
        private final Map<String, List<DeprecationIssue>> pluginSettingsIssues;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.clusterSettingsIssues = in.readCollectionAsList(DeprecationIssue::new);
            this.nodeSettingsIssues = in.readCollectionAsList(DeprecationIssue::new);
            this.indexSettingsIssues = in.readMapOfLists(DeprecationIssue::new);
            if (in.getTransportVersion().before((VersionId)TransportVersions.V_7_11_0)) {
                List mlIssues = in.readCollectionAsList(DeprecationIssue::new);
                this.pluginSettingsIssues = new HashMap<String, List<DeprecationIssue>>();
                this.pluginSettingsIssues.put("ml_settings", mlIssues);
            } else {
                this.pluginSettingsIssues = in.readMapOfLists(DeprecationIssue::new);
            }
        }

        public Response(List<DeprecationIssue> clusterSettingsIssues, List<DeprecationIssue> nodeSettingsIssues, Map<String, List<DeprecationIssue>> indexSettingsIssues, Map<String, List<DeprecationIssue>> pluginSettingsIssues) {
            this.clusterSettingsIssues = clusterSettingsIssues;
            this.nodeSettingsIssues = nodeSettingsIssues;
            this.indexSettingsIssues = indexSettingsIssues;
            Set intersection = Sets.intersection(RESERVED_NAMES, pluginSettingsIssues.keySet());
            if (!intersection.isEmpty()) {
                throw new ElasticsearchStatusException("Unable to discover deprecations as plugin deprecation names overlap with reserved names {}", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{intersection});
            }
            this.pluginSettingsIssues = pluginSettingsIssues;
        }

        public List<DeprecationIssue> getClusterSettingsIssues() {
            return this.clusterSettingsIssues;
        }

        public List<DeprecationIssue> getNodeSettingsIssues() {
            return this.nodeSettingsIssues;
        }

        public Map<String, List<DeprecationIssue>> getIndexSettingsIssues() {
            return this.indexSettingsIssues;
        }

        public Map<String, List<DeprecationIssue>> getPluginSettingsIssues() {
            return this.pluginSettingsIssues;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.clusterSettingsIssues);
            out.writeCollection(this.nodeSettingsIssues);
            out.writeMap(this.indexSettingsIssues, StreamOutput::writeCollection);
            if (out.getTransportVersion().before((VersionId)TransportVersions.V_7_11_0)) {
                out.writeCollection((Collection)this.pluginSettingsIssues.getOrDefault("ml_settings", Collections.emptyList()));
            } else {
                out.writeMap(this.pluginSettingsIssues, StreamOutput::writeCollection);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().array("cluster_settings", this.clusterSettingsIssues.toArray()).array("node_settings", this.nodeSettingsIssues.toArray()).field("index_settings").map(this.indexSettingsIssues).mapContents(this.pluginSettingsIssues).endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.clusterSettingsIssues, response.clusterSettingsIssues) && Objects.equals(this.nodeSettingsIssues, response.nodeSettingsIssues) && Objects.equals(this.indexSettingsIssues, response.indexSettingsIssues) && Objects.equals(this.pluginSettingsIssues, response.pluginSettingsIssues);
        }

        public int hashCode() {
            return Objects.hash(this.clusterSettingsIssues, this.nodeSettingsIssues, this.indexSettingsIssues, this.pluginSettingsIssues);
        }

        public static Response from(ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver, Request request, NodesDeprecationCheckResponse nodeDeprecationResponse, List<Function<IndexMetadata, DeprecationIssue>> indexSettingsChecks, List<Function<ClusterState, DeprecationIssue>> clusterSettingsChecks, Map<String, List<DeprecationIssue>> pluginSettingIssues, List<String> skipTheseDeprecatedSettings) {
            assert (Transports.assertNotTransportThread((String)"walking mappings in indexSettingsChecks is expensive"));
            String[] concreteIndexNames = indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request);
            ClusterState stateWithSkippedSettingsRemoved = DeprecationInfoAction.removeSkippedSettings(state, concreteIndexNames, skipTheseDeprecatedSettings);
            List<DeprecationIssue> clusterSettingsIssues = DeprecationInfoAction.filterChecks(clusterSettingsChecks, c -> (DeprecationIssue)c.apply(stateWithSkippedSettingsRemoved));
            List<DeprecationIssue> nodeSettingsIssues = DeprecationInfoAction.mergeNodeIssues(nodeDeprecationResponse);
            HashMap<String, List<DeprecationIssue>> indexSettingsIssues = new HashMap<String, List<DeprecationIssue>>();
            for (String concreteIndex : concreteIndexNames) {
                IndexMetadata indexMetadata = stateWithSkippedSettingsRemoved.getMetadata().index(concreteIndex);
                List<DeprecationIssue> singleIndexIssues = DeprecationInfoAction.filterChecks(indexSettingsChecks, c -> (DeprecationIssue)c.apply(indexMetadata));
                if (singleIndexIssues.size() <= 0) continue;
                indexSettingsIssues.put(concreteIndex, singleIndexIssues);
            }
            List<DeprecationIssue> transformDeprecations = pluginSettingIssues.remove("transform_settings");
            if (transformDeprecations != null) {
                clusterSettingsIssues.addAll(transformDeprecations);
            }
            return new Response(clusterSettingsIssues, nodeSettingsIssues, indexSettingsIssues, pluginSettingIssues);
        }
    }
}

