/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.action.AbstractSqlQueryRequest;
import org.elasticsearch.xpack.sql.action.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.proto.CoreProtocol;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.RequestInfo;

public class SqlClearCursorRequest
extends AbstractSqlRequest {
    static final ParseField BINARY_FORMAT = new ParseField("binary_format", new String[0]);
    private static final ConstructingObjectParser<SqlClearCursorRequest, Void> PARSER = new ConstructingObjectParser("indices:data/read/sql/close_cursor", objects -> {
        RequestInfo requestInfo = new RequestInfo(Mode.fromString((String)((String)objects[1])), (String)objects[2]);
        return new SqlClearCursorRequest(requestInfo, (String)objects[0]);
    });
    private String cursor;
    private Boolean binaryCommunication = CoreProtocol.BINARY_COMMUNICATION;

    public SqlClearCursorRequest() {
    }

    public SqlClearCursorRequest(RequestInfo requestInfo, String cursor) {
        super(requestInfo);
        this.cursor = cursor;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.getCursor() == null) {
            validationException = ValidateActions.addValidationError((String)"cursor is required", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getCursor() {
        return this.cursor;
    }

    public SqlClearCursorRequest setCursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    public String getDescription() {
        return "SQL Clean cursor [" + this.getCursor() + "]";
    }

    public SqlClearCursorRequest(StreamInput in) throws IOException {
        super(in);
        this.cursor = in.readString();
        this.binaryCommunication = in.readOptionalBoolean();
    }

    public SqlClearCursorRequest binaryCommunication(Boolean binaryCommunication) {
        this.binaryCommunication = binaryCommunication;
        return this;
    }

    public Boolean binaryCommunication() {
        return this.binaryCommunication;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cursor);
        out.writeOptionalBoolean(this.binaryCommunication);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SqlClearCursorRequest that = (SqlClearCursorRequest)((Object)o);
        return Objects.equals(this.cursor, that.cursor) && Objects.equals(this.binaryCommunication, that.binaryCommunication);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cursor, this.binaryCommunication);
    }

    public static SqlClearCursorRequest fromXContent(XContentParser parser) {
        return (SqlClearCursorRequest)((Object)PARSER.apply(parser, null));
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), AbstractSqlQueryRequest.CURSOR);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), AbstractSqlQueryRequest.MODE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), AbstractSqlQueryRequest.CLIENT_ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), AbstractSqlQueryRequest.VERSION);
        PARSER.declareBoolean(SqlClearCursorRequest::binaryCommunication, BINARY_FORMAT);
    }
}

