/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.rankeval.EvaluationMetric;
import org.elasticsearch.index.rankeval.MetricDetail;
import org.elasticsearch.index.rankeval.RatedDocument;
import org.elasticsearch.index.rankeval.RatedSearchHit;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class EvalQueryQuality
implements ToXContentFragment,
Writeable {
    private final String queryId;
    private final double metricScore;
    private MetricDetail optionalMetricDetails;
    private final List<RatedSearchHit> ratedHits;
    static final ParseField METRIC_SCORE_FIELD = new ParseField("metric_score", new String[0]);
    private static final ParseField UNRATED_DOCS_FIELD = new ParseField("unrated_docs", new String[0]);
    static final ParseField HITS_FIELD = new ParseField("hits", new String[0]);
    static final ParseField METRIC_DETAILS_FIELD = new ParseField("metric_details", new String[0]);

    public EvalQueryQuality(String id, double metricScore) {
        this(id, metricScore, new ArrayList<RatedSearchHit>(), null);
    }

    public EvalQueryQuality(StreamInput in) throws IOException {
        this(in.readString(), in.readDouble(), in.readCollectionAsList(RatedSearchHit::new), (MetricDetail)in.readOptionalNamedWriteable(MetricDetail.class));
    }

    EvalQueryQuality(String queryId, double evaluationResult, List<RatedSearchHit> ratedHits, MetricDetail optionalMetricDetails) {
        this.queryId = queryId;
        this.metricScore = evaluationResult;
        this.optionalMetricDetails = optionalMetricDetails;
        this.ratedHits = ratedHits;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.queryId);
        out.writeDouble(this.metricScore);
        out.writeCollection(this.ratedHits);
        out.writeOptionalNamedWriteable((NamedWriteable)this.optionalMetricDetails);
    }

    public String getId() {
        return this.queryId;
    }

    public double metricScore() {
        return this.metricScore;
    }

    public void setMetricDetails(MetricDetail breakdown) {
        this.optionalMetricDetails = breakdown;
    }

    public MetricDetail getMetricDetails() {
        return this.optionalMetricDetails;
    }

    public void addHitsAndRatings(List<RatedSearchHit> hits) {
        this.ratedHits.addAll(hits);
    }

    public List<RatedSearchHit> getHitsAndRatings() {
        return this.ratedHits;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.queryId);
        builder.field(METRIC_SCORE_FIELD.getPreferredName(), this.metricScore);
        builder.startArray(UNRATED_DOCS_FIELD.getPreferredName());
        for (RatedDocument.DocumentKey key : EvaluationMetric.filterUnratedDocuments(this.ratedHits)) {
            builder.startObject();
            builder.field(RatedDocument.INDEX_FIELD.getPreferredName(), key.index());
            builder.field(RatedDocument.DOC_ID_FIELD.getPreferredName(), key.docId());
            builder.endObject();
        }
        builder.endArray();
        builder.startArray(HITS_FIELD.getPreferredName());
        for (RatedSearchHit hit : this.ratedHits) {
            hit.toXContent(builder, params);
        }
        builder.endArray();
        if (this.optionalMetricDetails != null) {
            builder.field(METRIC_DETAILS_FIELD.getPreferredName(), (ToXContent)this.optionalMetricDetails);
        }
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EvalQueryQuality other = (EvalQueryQuality)obj;
        return Objects.equals(this.queryId, other.queryId) && Objects.equals(this.metricScore, other.metricScore) && Objects.equals(this.ratedHits, other.ratedHits) && Objects.equals(this.optionalMetricDetails, other.optionalMetricDetails);
    }

    public final int hashCode() {
        return Objects.hash(this.queryId, this.metricScore, this.ratedHits, this.optionalMetricDetails);
    }
}

