/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.tensor;

import org.ojalgo.array.DenseArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.tensor.Tensor;
import org.ojalgo.type.NumberDefinition;

abstract class ArrayBasedTensor<N extends Comparable<N>, T extends ArrayBasedTensor<N, T>>
implements Tensor<N, T> {
    private final int myDimensions;
    private final FunctionSet<N> myFunctionSet;
    private final int myRank;
    private final Scalar.Factory<N> myScalarFactory;

    ArrayBasedTensor(int rank, int dimensions, FunctionSet<N> functionSet, Scalar.Factory<N> scalarFactory) {
        this.myRank = rank;
        this.myDimensions = dimensions;
        this.myFunctionSet = functionSet;
        this.myScalarFactory = scalarFactory;
    }

    @Override
    public final int dimensions() {
        return this.myDimensions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayBasedTensor)) {
            return false;
        }
        ArrayBasedTensor other = (ArrayBasedTensor)obj;
        if (this.myDimensions != other.myDimensions) {
            return false;
        }
        if (this.myFunctionSet == null ? other.myFunctionSet != null : !this.myFunctionSet.equals(other.myFunctionSet)) {
            return false;
        }
        if (this.myRank != other.myRank) {
            return false;
        }
        return !(this.myScalarFactory == null ? other.myScalarFactory != null : !this.myScalarFactory.equals(other.myScalarFactory));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.myDimensions;
        result = 31 * result + (this.myFunctionSet == null ? 0 : this.myFunctionSet.hashCode());
        result = 31 * result + this.myRank;
        result = 31 * result + (this.myScalarFactory == null ? 0 : this.myScalarFactory.hashCode());
        return result;
    }

    @Override
    public final int rank() {
        return this.myRank;
    }

    @Override
    public T signum() {
        return (T)((ArrayBasedTensor)this.multiply(PrimitiveMath.ONE / this.norm()));
    }

    void add(Mutate1D.Fillable<N> receiver, Access1D<N> left, Access1D<N> right) {
        receiver.fillMatching(left, this.myFunctionSet.add(), right);
    }

    void multiply(Mutate1D.Fillable<N> receiver, double left, Access1D<N> right) {
        receiver.fillMatching(this.myFunctionSet.multiply().first(left), right);
    }

    void multiply(Mutate1D.Fillable<N> receiver, N left, Access1D<N> right) {
        receiver.fillMatching(this.myFunctionSet.multiply().first(left), right);
    }

    void negate(Mutate1D.Fillable<N> receiver, Access1D<N> argument) {
        receiver.fillMatching(this.myFunctionSet.negate(), argument);
    }

    abstract T newSameShape();

    double norm(Access1D.Aggregatable<N> array) {
        double frobeniusNorm = NumberDefinition.doubleValue(array.aggregateAll(Aggregator.NORM2));
        switch (this.rank()) {
            case 1: {
                return frobeniusNorm;
            }
            case 2: {
                return frobeniusNorm / (double)PrimitiveMath.SQRT.invoke(this.dimensions());
            }
        }
        return frobeniusNorm / (double)PrimitiveMath.ROOT.invoke(this.dimensions(), this.rank());
    }

    public static abstract class Factory<N extends Comparable<N>> {
        private final DenseArray.Factory<N> myArrayFactory;

        Factory(DenseArray.Factory<N> arrayFactory) {
            this.myArrayFactory = arrayFactory;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Factory)) {
                return false;
            }
            Factory other = (Factory)obj;
            return !(this.myArrayFactory == null ? other.myArrayFactory != null : !this.myArrayFactory.equals(other.myArrayFactory));
        }

        public FunctionSet<N> function() {
            return this.myArrayFactory.function();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myArrayFactory == null ? 0 : this.myArrayFactory.hashCode());
            return result;
        }

        public Scalar.Factory<N> scalar() {
            return this.myArrayFactory.scalar();
        }

        DenseArray.Factory<N> getArrayFactory() {
            return this.myArrayFactory;
        }
    }
}

