/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.ShadingStore;
import org.ojalgo.scalar.Scalar;

final class LowerTriangularStore<N extends Comparable<N>>
extends ShadingStore<N> {
    private final boolean myUnitDiagonal;

    LowerTriangularStore(MatrixStore<N> base, boolean unitDiagonal) {
        super(base);
        this.myUnitDiagonal = unitDiagonal;
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row < col) {
            return PrimitiveMath.ZERO;
        }
        if (this.myUnitDiagonal && row == col) {
            return PrimitiveMath.ONE;
        }
        return this.base().doubleValue(row, col);
    }

    @Override
    public int firstInColumn(int col) {
        return col;
    }

    @Override
    public N get(long row, long col) {
        if (row < col) {
            return (N)((Comparable)this.zero().get());
        }
        if (this.myUnitDiagonal && row == col) {
            return (N)((Comparable)this.one().get());
        }
        return this.base().get(row, col);
    }

    @Override
    public int limitOfRow(int row) {
        return Math.min(row + 1, this.getColDim());
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        if (row < col) {
            return this.zero();
        }
        if (this.myUnitDiagonal && row == col) {
            return this.one();
        }
        return this.base().toScalar(row, col);
    }
}

