/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.io.LegacyShapeWriter;
import org.locationtech.spatial4j.io.ShapeWriter;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.impl.BufferedLine;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;
import org.locationtech.spatial4j.shape.impl.GeoCircle;

public class GeoJSONWriter
implements ShapeWriter {
    public GeoJSONWriter(SpatialContext ctx, SpatialContextFactory factory) {
    }

    @Override
    public String getFormatName() {
        return "GeoJSON";
    }

    protected void write(Writer output, NumberFormat nf, double ... coords) throws IOException {
        output.write(91);
        for (int i = 0; i < coords.length; ++i) {
            if (i > 0) {
                output.append(',');
            }
            output.append(nf.format(coords[i]));
        }
        output.write(93);
    }

    @Override
    public void write(Writer output, Shape shape) throws IOException {
        if (shape == null) {
            throw new NullPointerException("Shape can not be null");
        }
        NumberFormat nf = LegacyShapeWriter.makeNumberFormat(6);
        if (shape instanceof Point) {
            Point v = (Point)shape;
            output.append("{\"type\":\"Point\",\"coordinates\":");
            this.write(output, nf, v.getX(), v.getY());
            output.append('}');
            return;
        }
        if (shape instanceof Rectangle) {
            Rectangle v = (Rectangle)shape;
            output.append("{\"type\":\"Polygon\",\"coordinates\":[[");
            this.write(output, nf, v.getMinX(), v.getMinY());
            output.append(',');
            this.write(output, nf, v.getMinX(), v.getMaxY());
            output.append(',');
            this.write(output, nf, v.getMaxX(), v.getMaxY());
            output.append(',');
            this.write(output, nf, v.getMaxX(), v.getMinY());
            output.append(',');
            this.write(output, nf, v.getMinX(), v.getMinY());
            output.append("]]}");
            return;
        }
        if (shape instanceof BufferedLine) {
            BufferedLine v = (BufferedLine)shape;
            output.append("{\"type\":\"LineString\",\"coordinates\":[");
            this.write(output, nf, v.getA().getX(), v.getA().getY());
            output.append(',');
            this.write(output, nf, v.getB().getX(), v.getB().getY());
            output.append(',');
            output.append("]");
            if (v.getBuf() > 0.0) {
                output.append(',');
                output.append("\"buffer\":");
                output.append(nf.format(v.getBuf()));
            }
            output.append('}');
            return;
        }
        if (shape instanceof BufferedLineString) {
            BufferedLineString v = (BufferedLineString)shape;
            output.append("{\"type\":\"LineString\",\"coordinates\":[");
            BufferedLine last = null;
            for (BufferedLine seg : v.getSegments()) {
                if (last != null) {
                    output.append(',');
                }
                this.write(output, nf, seg.getA().getX(), seg.getA().getY());
                last = seg;
            }
            if (last != null) {
                output.append(',');
                this.write(output, nf, last.getB().getX(), last.getB().getY());
            }
            output.append("]");
            if (v.getBuf() > 0.0) {
                this.writeDistance(output, nf, v.getBuf(), shape.getContext().isGeo(), "buffer", "buffer_units");
            }
            output.append('}');
            return;
        }
        if (shape instanceof Circle) {
            Circle v = (Circle)shape;
            Point center = v.getCenter();
            output.append("{\"type\":\"Circle\",\"coordinates\":");
            this.write(output, nf, center.getX(), center.getY());
            this.writeDistance(output, nf, v.getRadius(), v instanceof GeoCircle, "radius", "radius_units");
            output.append("}");
            return;
        }
        if (shape instanceof ShapeCollection) {
            ShapeCollection v = (ShapeCollection)shape;
            output.append("{\"type\":\"GeometryCollection\",\"geometries\":[");
            for (int i = 0; i < v.size(); ++i) {
                if (i > 0) {
                    output.append(',');
                }
                this.write(output, (Shape)v.get(i));
            }
            output.append("]}");
            return;
        }
        output.append("{\"type\":\"Unknown\",\"wkt\":\"");
        output.append(LegacyShapeWriter.writeShape(shape));
        output.append("\"}");
    }

    void writeDistance(Writer output, NumberFormat nf, double dist, boolean isGeo, String distProperty, String distUnitsProperty) throws IOException {
        output.append(",\"").append(distProperty).append("\":");
        if (isGeo) {
            double distKm = DistanceUtils.degrees2Dist(dist, 6371.0087714);
            output.append(nf.format(distKm));
            output.append(",\"properties\":{");
            output.append("\"").append(distUnitsProperty).append("\":\"km\"}");
        } else {
            output.append(nf.format(dist));
        }
    }

    @Override
    public String toString(Shape shape) {
        try {
            StringWriter buffer = new StringWriter();
            this.write(buffer, shape);
            return buffer.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

