/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.completion;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openai.OpenAiRateLimitServiceSettings;

public class OpenAiChatCompletionServiceSettings
implements ServiceSettings,
OpenAiRateLimitServiceSettings {
    public static final String NAME = "openai_completion_service_settings";
    private final String modelId;
    private final URI uri;
    private final String organizationId;
    private final Integer maxInputTokens;

    public static OpenAiChatCompletionServiceSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        String modelId = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        String organizationId = ServiceUtils.extractOptionalString(map, "organization_id", "service_settings", validationException);
        String url = ServiceUtils.extractOptionalString(map, "url", "service_settings", validationException);
        URI uri = ServiceUtils.convertToUri(url, "url", "service_settings", validationException);
        Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new OpenAiChatCompletionServiceSettings(modelId, uri, organizationId, maxInputTokens);
    }

    public OpenAiChatCompletionServiceSettings(String modelId, @Nullable URI uri, @Nullable String organizationId, @Nullable Integer maxInputTokens) {
        this.modelId = modelId;
        this.uri = uri;
        this.organizationId = organizationId;
        this.maxInputTokens = maxInputTokens;
    }

    OpenAiChatCompletionServiceSettings(String modelId, @Nullable String uri, @Nullable String organizationId, @Nullable Integer maxInputTokens) {
        this(modelId, ServiceUtils.createOptionalUri(uri), organizationId, maxInputTokens);
    }

    public OpenAiChatCompletionServiceSettings(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.uri = ServiceUtils.createOptionalUri(in.readOptionalString());
        this.organizationId = in.readOptionalString();
        this.maxInputTokens = in.readOptionalVInt();
    }

    @Override
    public String modelId() {
        return this.modelId;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public String organizationId() {
        return this.organizationId;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("model_id", this.modelId);
        if (this.uri != null) {
            builder.field("url", this.uri.toString());
        }
        if (this.organizationId != null) {
            builder.field("organization_id", this.organizationId);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_COMPLETION_INFERENCE_SERVICE_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeOptionalString(this.uri != null ? this.uri.toString() : null);
        out.writeOptionalString(this.organizationId);
        out.writeOptionalVInt(this.maxInputTokens);
    }

    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OpenAiChatCompletionServiceSettings that = (OpenAiChatCompletionServiceSettings)object;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.uri, that.uri) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.maxInputTokens, that.maxInputTokens);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.uri, this.organizationId, this.maxInputTokens);
    }
}

