/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.elser;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceServiceSettings;

public record HuggingFaceElserServiceSettings(URI uri, Integer maxInputTokens) implements ServiceSettings,
HuggingFaceRateLimitServiceSettings
{
    public static final String NAME = "hugging_face_elser_service_settings";
    private static final Integer ELSER_TOKEN_LIMIT = 512;
    static final String URL = "url";

    public HuggingFaceElserServiceSettings {
        Objects.requireNonNull(uri);
    }

    public HuggingFaceElserServiceSettings(String url) {
        this(ServiceUtils.createUri(url), ELSER_TOKEN_LIMIT);
    }

    public HuggingFaceElserServiceSettings(StreamInput in) throws IOException {
        this(in.readString());
    }

    public static HuggingFaceElserServiceSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        URI uri = HuggingFaceServiceSettings.extractUri(map, URL, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new HuggingFaceElserServiceSettings(uri, ELSER_TOKEN_LIMIT);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(URL, this.uri.toString());
        builder.field("max_input_tokens", this.maxInputTokens);
        builder.endObject();
        return builder;
    }

    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_12_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.uri.toString());
    }
}

