/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere;

import java.net.URI;
import java.util.Map;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.cohere.CohereActionVisitor;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;

public abstract class CohereModel
extends Model {
    private final SecureString apiKey;

    public CohereModel(ModelConfigurations configurations, ModelSecrets secrets, @Nullable ApiKeySecrets apiKeySecrets) {
        super(configurations, secrets);
        this.apiKey = ServiceUtils.apiKey(apiKeySecrets);
    }

    protected CohereModel(CohereModel model, TaskSettings taskSettings) {
        super((Model)model, taskSettings);
        this.apiKey = model.apiKey();
    }

    protected CohereModel(CohereModel model, ServiceSettings serviceSettings) {
        super((Model)model, serviceSettings);
        this.apiKey = model.apiKey();
    }

    public SecureString apiKey() {
        return this.apiKey;
    }

    public abstract ExecutableAction accept(CohereActionVisitor var1, Map<String, Object> var2, InputType var3);

    public abstract URI uri();
}

