/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.inference.results.ChunkedTextEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.ErrorChunkedInferenceResults;
import org.elasticsearch.xpack.core.inference.results.ResultUtils;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.ErrorInferenceResults;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.azureopenai.AzureOpenAiActionCreator;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiModel;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsServiceSettings;

public class AzureOpenAiService
extends SenderService {
    public static final String NAME = "azureopenai";

    public AzureOpenAiService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        super(factory, serviceComponents);
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Set<String> platformArchitectures, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            AzureOpenAiModel model = AzureOpenAiService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, serviceSettingsMap, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    private static AzureOpenAiModel createModelFromPersistent(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, String failureMessage) {
        return AzureOpenAiService.createModel(inferenceEntityId, taskType, serviceSettings, taskSettings, secretSettings, failureMessage, ConfigurationParseContext.PERSISTENT);
    }

    private static AzureOpenAiModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, String failureMessage, ConfigurationParseContext context) {
        if (taskType == TaskType.TEXT_EMBEDDING) {
            return new AzureOpenAiEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
        }
        throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
    }

    public AzureOpenAiModel parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(secrets, "secret_settings");
        return AzureOpenAiService.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public AzureOpenAiModel parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        return AzureOpenAiService.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, null, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    @Override
    protected void doInfer(Model model, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof AzureOpenAiModel)) {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
            return;
        }
        AzureOpenAiModel azureOpenAiModel = (AzureOpenAiModel)model;
        AzureOpenAiActionCreator actionCreator = new AzureOpenAiActionCreator(this.getSender(), this.getServiceComponents());
        ExecutableAction action = azureOpenAiModel.accept(actionCreator, taskSettings);
        action.execute(new DocumentsOnlyInput(input), timeout, listener);
    }

    @Override
    protected void doInfer(Model model, String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        throw new UnsupportedOperationException("Azure OpenAI service does not support inference with query input");
    }

    @Override
    protected void doChunkedInfer(Model model, String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        ActionListener inferListener = listener.delegateFailureAndWrap((delegate, response) -> delegate.onResponse(AzureOpenAiService.translateToChunkedResults(input, response)));
        this.doInfer(model, input, taskSettings, inputType, timeout, (ActionListener<InferenceServiceResults>)inferListener);
    }

    private static List<ChunkedInferenceServiceResults> translateToChunkedResults(List<String> inputs, InferenceServiceResults inferenceResults) {
        if (inferenceResults instanceof TextEmbeddingResults) {
            TextEmbeddingResults textEmbeddingResults = (TextEmbeddingResults)inferenceResults;
            return ChunkedTextEmbeddingResults.of(inputs, (TextEmbeddingResults)textEmbeddingResults);
        }
        if (inferenceResults instanceof ErrorInferenceResults) {
            ErrorInferenceResults error = (ErrorInferenceResults)inferenceResults;
            return List.of(new ErrorChunkedInferenceResults(error.getException()));
        }
        throw ResultUtils.createInvalidChunkedResultException((String)inferenceResults.getWriteableName());
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        if (model instanceof AzureOpenAiEmbeddingsModel) {
            AzureOpenAiEmbeddingsModel embeddingsModel = (AzureOpenAiEmbeddingsModel)model;
            ServiceUtils.getEmbeddingSize(model, this, (ActionListener<Integer>)listener.delegateFailureAndWrap((l, size) -> l.onResponse((Object)this.updateModelWithEmbeddingDetails(embeddingsModel, (int)size))));
        } else {
            listener.onResponse((Object)model);
        }
    }

    private AzureOpenAiEmbeddingsModel updateModelWithEmbeddingDetails(AzureOpenAiEmbeddingsModel model, int embeddingSize) {
        if (model.getServiceSettings().dimensionsSetByUser().booleanValue() && model.getServiceSettings().dimensions() != null && model.getServiceSettings().dimensions() != embeddingSize) {
            throw new ElasticsearchStatusException(Strings.format((String)"The retrieved embeddings size [%s] does not match the size specified in the settings [%s]. Please recreate the [%s] configuration with the correct dimensions", (Object[])new Object[]{embeddingSize, model.getServiceSettings().dimensions(), model.getConfigurations().getInferenceEntityId()}), RestStatus.BAD_REQUEST, new Object[0]);
        }
        SimilarityMeasure similarityFromModel = model.getServiceSettings().similarity();
        SimilarityMeasure similarityToUse = similarityFromModel == null ? SimilarityMeasure.DOT_PRODUCT : similarityFromModel;
        AzureOpenAiEmbeddingsServiceSettings serviceSettings = new AzureOpenAiEmbeddingsServiceSettings(model.getServiceSettings().resourceName(), model.getServiceSettings().deploymentId(), model.getServiceSettings().apiVersion(), embeddingSize, model.getServiceSettings().dimensionsSetByUser(), model.getServiceSettings().maxInputTokens(), similarityToUse);
        return new AzureOpenAiEmbeddingsModel(model, serviceSettings);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_AZURE_OPENAI_EMBEDDINGS;
    }
}

