/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.azureopenai.AzureOpenAiActionVisitor;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiRateLimitServiceSettings;

public abstract class AzureOpenAiModel
extends Model {
    protected URI uri;
    private final AzureOpenAiRateLimitServiceSettings rateLimitServiceSettings;

    public AzureOpenAiModel(ModelConfigurations configurations, ModelSecrets secrets, AzureOpenAiRateLimitServiceSettings rateLimitServiceSettings) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
    }

    protected AzureOpenAiModel(AzureOpenAiModel model, TaskSettings taskSettings) {
        super((Model)model, taskSettings);
        this.uri = model.getUri();
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
    }

    protected AzureOpenAiModel(AzureOpenAiModel model, ServiceSettings serviceSettings) {
        super((Model)model, serviceSettings);
        this.uri = model.getUri();
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
    }

    public abstract ExecutableAction accept(AzureOpenAiActionVisitor var1, Map<String, Object> var2);

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI newUri) {
        this.uri = newUri;
    }

    public AzureOpenAiRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }
}

