/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.openai;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.openai.OpenAiAccount;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.external.request.openai.OpenAiChatCompletionRequestEntity;
import org.elasticsearch.xpack.inference.external.request.openai.OpenAiRequest;
import org.elasticsearch.xpack.inference.external.request.openai.OpenAiUtils;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionModel;

public class OpenAiChatCompletionRequest
implements OpenAiRequest {
    private final OpenAiAccount account;
    private final List<String> input;
    private final OpenAiChatCompletionModel model;

    public OpenAiChatCompletionRequest(List<String> input, OpenAiChatCompletionModel model) {
        this.account = OpenAiAccount.of(model, (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)OpenAiChatCompletionRequest::buildDefaultUri));
        this.input = Objects.requireNonNull(input);
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.account.uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new OpenAiChatCompletionRequestEntity(this.input, this.model.getServiceSettings().modelId(), this.model.getTaskSettings().user())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        httpPost.setHeader(RequestUtils.createAuthBearerHeader(this.account.apiKey()));
        String org = this.account.organizationId();
        if (org != null) {
            httpPost.setHeader(OpenAiUtils.createOrgHeader(org));
        }
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public URI getURI() {
        return this.account.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    public static URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.openai.com").setPathSegments(new String[]{"v1", "chat", "completions"}).build();
    }
}

