/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.cohere;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.cohere.CohereAccount;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.external.request.cohere.CohereEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.external.request.cohere.CohereUtils;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingType;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsTaskSettings;

public class CohereEmbeddingsRequest
implements Request {
    private final CohereAccount account;
    private final List<String> input;
    private final CohereEmbeddingsTaskSettings taskSettings;
    private final String model;
    private final CohereEmbeddingType embeddingType;
    private final String inferenceEntityId;

    public CohereEmbeddingsRequest(List<String> input, CohereEmbeddingsModel embeddingsModel) {
        Objects.requireNonNull(embeddingsModel);
        this.account = CohereAccount.of(embeddingsModel, (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)CohereEmbeddingsRequest::buildDefaultUri));
        this.input = Objects.requireNonNull(input);
        this.taskSettings = embeddingsModel.getTaskSettings();
        this.model = embeddingsModel.getServiceSettings().getCommonSettings().modelId();
        this.embeddingType = embeddingsModel.getServiceSettings().getEmbeddingType();
        this.inferenceEntityId = embeddingsModel.getInferenceEntityId();
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.account.uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new CohereEmbeddingsRequestEntity(this.input, this.taskSettings, this.model, this.embeddingType)).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        httpPost.setHeader(RequestUtils.createAuthBearerHeader(this.account.apiKey()));
        httpPost.setHeader(CohereUtils.createRequestSourceHeader());
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.inferenceEntityId;
    }

    @Override
    public URI getURI() {
        return this.account.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    public static URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.cohere.ai").setPathSegments(new String[]{"v1", "embed"}).build();
    }
}

