/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class RequestExecutorServiceSettings {
    static final Setting<Integer> TASK_QUEUE_CAPACITY_SETTING = Setting.intSetting((String)"xpack.inference.http.request_executor.queue_capacity", (int)2000, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private volatile int queueCapacity;
    private final List<Consumer<Integer>> queueCapacityCallbacks = new ArrayList<Consumer<Integer>>();

    public static List<Setting<?>> getSettingsDefinitions() {
        return List.of(TASK_QUEUE_CAPACITY_SETTING);
    }

    public RequestExecutorServiceSettings(Settings settings, ClusterService clusterService) {
        this.queueCapacity = (Integer)TASK_QUEUE_CAPACITY_SETTING.get(settings);
        this.addSettingsUpdateConsumers(clusterService);
    }

    private void addSettingsUpdateConsumers(ClusterService clusterService) {
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TASK_QUEUE_CAPACITY_SETTING, this::setQueueCapacity);
    }

    void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        for (Consumer<Integer> callback : this.queueCapacityCallbacks) {
            callback.accept(queueCapacity);
        }
    }

    void registerQueueCapacityCallback(Consumer<Integer> onChangeCapacityCallback) {
        this.queueCapacityCallbacks.add(onChangeCapacityCallback);
    }

    int getQueueCapacity() {
        return this.queueCapacity;
    }
}

