/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.OpenAiRequestManager;
import org.elasticsearch.xpack.inference.external.openai.OpenAiChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.external.request.openai.OpenAiChatCompletionRequest;
import org.elasticsearch.xpack.inference.external.response.openai.OpenAiChatCompletionResponseEntity;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionModel;

public class OpenAiCompletionRequestManager
extends OpenAiRequestManager {
    private static final Logger logger = LogManager.getLogger(OpenAiCompletionRequestManager.class);
    private static final ResponseHandler HANDLER = OpenAiCompletionRequestManager.createCompletionHandler();
    private final OpenAiChatCompletionModel model;

    public static OpenAiCompletionRequestManager of(OpenAiChatCompletionModel model, ThreadPool threadPool) {
        return new OpenAiCompletionRequestManager(Objects.requireNonNull(model), Objects.requireNonNull(threadPool));
    }

    private OpenAiCompletionRequestManager(OpenAiChatCompletionModel model, ThreadPool threadPool) {
        super(threadPool, model, (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)OpenAiChatCompletionRequest::buildDefaultUri));
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public Runnable create(@Nullable String query, List<String> input, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, HttpClientContext context, ActionListener<InferenceServiceResults> listener) {
        OpenAiChatCompletionRequest request = new OpenAiChatCompletionRequest(input, this.model);
        return new ExecutableInferenceRequest(requestSender, logger, request, context, HANDLER, hasRequestCompletedFunction, listener);
    }

    private static ResponseHandler createCompletionHandler() {
        return new OpenAiChatCompletionResponseHandler("openai completion", OpenAiChatCompletionResponseEntity::fromResponse);
    }
}

