/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.function.Supplier;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.request.Request;

record ExecutableInferenceRequest(RequestSender requestSender, Logger logger, Request request, HttpClientContext context, ResponseHandler responseHandler, Supplier<Boolean> hasFinished, ActionListener<InferenceServiceResults> listener) implements Runnable
{
    @Override
    public void run() {
        String inferenceEntityId = this.request.createHttpRequest().inferenceEntityId();
        try {
            this.requestSender.send(this.logger, this.request, this.context, this.hasFinished, this.responseHandler, this.listener);
        }
        catch (Exception e) {
            String errorMessage = Strings.format((String)"Failed to send request from inference entity id [%s]", (Object[])new Object[]{inferenceEntityId});
            this.logger.warn(errorMessage, (Throwable)e);
            this.listener.onFailure((Exception)((Object)new ElasticsearchException(errorMessage, (Throwable)e, new Object[0])));
        }
    }
}

