/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.cohere.CohereResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.CohereRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.request.cohere.CohereEmbeddingsRequest;
import org.elasticsearch.xpack.inference.external.response.cohere.CohereEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsModel;

public class CohereEmbeddingsRequestManager
extends CohereRequestManager {
    private static final Logger logger = LogManager.getLogger(CohereEmbeddingsRequestManager.class);
    private static final ResponseHandler HANDLER = CohereEmbeddingsRequestManager.createEmbeddingsHandler();
    private final CohereEmbeddingsModel model;

    private static ResponseHandler createEmbeddingsHandler() {
        return new CohereResponseHandler("cohere text embedding", CohereEmbeddingsResponseEntity::fromResponse);
    }

    public static CohereEmbeddingsRequestManager of(CohereEmbeddingsModel model, ThreadPool threadPool) {
        return new CohereEmbeddingsRequestManager(Objects.requireNonNull(model), Objects.requireNonNull(threadPool));
    }

    private CohereEmbeddingsRequestManager(CohereEmbeddingsModel model, ThreadPool threadPool) {
        super(threadPool, model);
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public Runnable create(String query, List<String> input, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, HttpClientContext context, ActionListener<InferenceServiceResults> listener) {
        CohereEmbeddingsRequest request = new CohereEmbeddingsRequest(input, this.model);
        return new ExecutableInferenceRequest(requestSender, logger, request, context, HANDLER, hasRequestCompletedFunction, listener);
    }
}

