/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorMessage;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;

public abstract class BaseResponseHandler
implements ResponseHandler {
    public static final String SERVER_ERROR = "Received a server error status code";
    public static final String RATE_LIMIT = "Received a rate limit status code";
    public static final String AUTHENTICATION = "Received an authentication error status code";
    public static final String REDIRECTION = "Unhandled redirection";
    public static final String CONTENT_TOO_LARGE = "Received a content too large status code";
    public static final String UNSUCCESSFUL = "Received an unsuccessful status code";
    protected final String requestType;
    private final ResponseParser parseFunction;
    private final Function<HttpResult, ErrorMessage> errorParseFunction;

    public BaseResponseHandler(String requestType, ResponseParser parseFunction, Function<HttpResult, ErrorMessage> errorParseFunction) {
        this.requestType = Objects.requireNonNull(requestType);
        this.parseFunction = Objects.requireNonNull(parseFunction);
        this.errorParseFunction = Objects.requireNonNull(errorParseFunction);
    }

    @Override
    public InferenceServiceResults parseResult(Request request, HttpResult result) throws RetryException {
        try {
            return this.parseFunction.apply(request, result);
        }
        catch (Exception e) {
            throw new RetryException(true, e);
        }
    }

    @Override
    public String getRequestType() {
        return this.requestType;
    }

    protected Exception buildError(String message, Request request, HttpResult result) {
        ErrorMessage errorEntityMsg = this.errorParseFunction.apply(result);
        int responseStatusCode = result.response().getStatusLine().getStatusCode();
        if (errorEntityMsg == null) {
            return new ElasticsearchStatusException(Strings.format((String)"%s for request from inference entity id [%s] status [%s]", (Object[])new Object[]{message, request.getInferenceEntityId(), responseStatusCode}), BaseResponseHandler.toRestStatus(responseStatusCode), new Object[0]);
        }
        return new ElasticsearchStatusException(Strings.format((String)"%s for request from inference entity id [%s] status [%s]. Error message: [%s]", (Object[])new Object[]{message, request.getInferenceEntityId(), responseStatusCode, errorEntityMsg.getErrorMessage()}), BaseResponseHandler.toRestStatus(responseStatusCode), new Object[0]);
    }

    public static RestStatus toRestStatus(int statusCode) {
        RestStatus code = null;
        if (statusCode < 500) {
            code = RestStatus.fromCode((int)statusCode);
        }
        return code == null ? RestStatus.BAD_REQUEST : code;
    }
}

