/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.Optional;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.Model;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportInferenceAction
extends HandledTransportAction<InferenceAction.Request, InferenceAction.Response> {
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;

    @Inject
    public TransportInferenceAction(TransportService transportService, ActionFilters actionFilters, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry) {
        super("cluster:monitor/xpack/inference", transportService, actionFilters, InferenceAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
    }

    protected void doExecute(Task task, InferenceAction.Request request, ActionListener<InferenceAction.Response> listener) {
        ActionListener getModelListener = listener.delegateFailureAndWrap((delegate, unparsedModel) -> {
            Optional service = this.serviceRegistry.getService(unparsedModel.service());
            if (service.isEmpty()) {
                delegate.onFailure((Exception)new ElasticsearchStatusException("Unknown service [{}] for model [{}]. ", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{unparsedModel.service(), unparsedModel.inferenceEntityId()}));
                return;
            }
            if (!request.getTaskType().isAnyOrSame(unparsedModel.taskType())) {
                delegate.onFailure((Exception)new ElasticsearchStatusException("Incompatible task_type, the requested type [{}] does not match the model type [{}]", RestStatus.BAD_REQUEST, new Object[]{request.getTaskType(), unparsedModel.taskType()}));
                return;
            }
            Model model = ((InferenceService)service.get()).parsePersistedConfigWithSecrets(unparsedModel.inferenceEntityId(), unparsedModel.taskType(), unparsedModel.settings(), unparsedModel.secrets());
            this.inferOnService(model, request, (InferenceService)service.get(), (ActionListener<InferenceAction.Response>)delegate);
        });
        this.modelRegistry.getModelWithSecrets(request.getInferenceEntityId(), (ActionListener<ModelRegistry.UnparsedModel>)getModelListener);
    }

    private void inferOnService(Model model, InferenceAction.Request request, InferenceService service, ActionListener<InferenceAction.Response> listener) {
        service.infer(model, request.getQuery(), request.getInput(), request.getTaskSettings(), request.getInputType(), request.getInferenceTimeout(), listener.delegateFailureAndWrap((l, inferenceResults) -> l.onResponse((Object)new InferenceAction.Response(inferenceResults))));
    }
}

