/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.GetInferenceModelAction;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportGetInferenceModelAction
extends HandledTransportAction<GetInferenceModelAction.Request, GetInferenceModelAction.Response> {
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;
    private final Executor executor;

    @Inject
    public TransportGetInferenceModelAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry) {
        super("cluster:monitor/xpack/inference/get", transportService, actionFilters, GetInferenceModelAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
        this.executor = threadPool.executor("inference_utility");
    }

    protected void doExecute(Task task, GetInferenceModelAction.Request request, ActionListener<GetInferenceModelAction.Response> listener) {
        boolean inferenceEntityIdIsWildCard = Strings.isAllOrWildcard((String)request.getInferenceEntityId());
        if (request.getTaskType() == TaskType.ANY && inferenceEntityIdIsWildCard) {
            this.getAllModels(listener);
        } else if (inferenceEntityIdIsWildCard) {
            this.getModelsByTaskType(request.getTaskType(), listener);
        } else {
            this.getSingleModel(request.getInferenceEntityId(), request.getTaskType(), listener);
        }
    }

    private void getSingleModel(String inferenceEntityId, TaskType requestedTaskType, ActionListener<GetInferenceModelAction.Response> listener) {
        this.modelRegistry.getModel(inferenceEntityId, (ActionListener<ModelRegistry.UnparsedModel>)listener.delegateFailureAndWrap((delegate, unparsedModel) -> {
            Optional service = this.serviceRegistry.getService(unparsedModel.service());
            if (service.isEmpty()) {
                delegate.onFailure((Exception)new ElasticsearchStatusException("Unknown service [{}] for model [{}]. ", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{unparsedModel.service(), unparsedModel.inferenceEntityId()}));
                return;
            }
            if (!requestedTaskType.isAnyOrSame(unparsedModel.taskType())) {
                delegate.onFailure((Exception)new ElasticsearchStatusException("Requested task type [{}] does not match the model's task type [{}]", RestStatus.BAD_REQUEST, new Object[]{requestedTaskType, unparsedModel.taskType()}));
                return;
            }
            Model model = ((InferenceService)service.get()).parsePersistedConfig(unparsedModel.inferenceEntityId(), unparsedModel.taskType(), unparsedModel.settings());
            delegate.onResponse((Object)new GetInferenceModelAction.Response(List.of(model.getConfigurations())));
        }));
    }

    private void getAllModels(ActionListener<GetInferenceModelAction.Response> listener) {
        this.modelRegistry.getAllModels((ActionListener<List<ModelRegistry.UnparsedModel>>)listener.delegateFailureAndWrap((l, models) -> this.executor.execute((Runnable)ActionRunnable.supply((ActionListener)l, () -> this.parseModels((List<ModelRegistry.UnparsedModel>)models)))));
    }

    private void getModelsByTaskType(TaskType taskType, ActionListener<GetInferenceModelAction.Response> listener) {
        this.modelRegistry.getModelsByTaskType(taskType, (ActionListener<List<ModelRegistry.UnparsedModel>>)listener.delegateFailureAndWrap((l, models) -> this.executor.execute((Runnable)ActionRunnable.supply((ActionListener)l, () -> this.parseModels((List<ModelRegistry.UnparsedModel>)models)))));
    }

    private GetInferenceModelAction.Response parseModels(List<ModelRegistry.UnparsedModel> unparsedModels) {
        ArrayList<ModelConfigurations> parsedModels = new ArrayList<ModelConfigurations>();
        for (ModelRegistry.UnparsedModel unparsedModel : unparsedModels) {
            Optional service = this.serviceRegistry.getService(unparsedModel.service());
            if (service.isEmpty()) {
                throw new ElasticsearchStatusException("Unknown service [{}] for model [{}]. ", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{unparsedModel.service(), unparsedModel.inferenceEntityId()});
            }
            parsedModels.add(((InferenceService)service.get()).parsePersistedConfig(unparsedModel.inferenceEntityId(), unparsedModel.taskType(), unparsedModel.settings()).getConfigurations());
        }
        return new GetInferenceModelAction.Response(parsedModels);
    }
}

