/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.DeleteInferenceModelAction;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportDeleteInferenceModelAction
extends AcknowledgedTransportMasterNodeAction<DeleteInferenceModelAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteInferenceModelAction.class);
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;

    @Inject
    public TransportDeleteInferenceModelAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry) {
        super("cluster:admin/xpack/inference/delete", transportService, clusterService, threadPool, actionFilters, DeleteInferenceModelAction.Request::new, indexNameExpressionResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
    }

    protected void masterOperation(Task task, DeleteInferenceModelAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        SubscribableListener.newForked(modelConfigListener -> this.modelRegistry.getModel(request.getInferenceEntityId(), (ActionListener<ModelRegistry.UnparsedModel>)modelConfigListener)).andThen((l1, unparsedModel) -> {
            if (!request.getTaskType().isAnyOrSame(unparsedModel.taskType())) {
                l1.onFailure((Exception)new ElasticsearchStatusException("Requested task type [{}] does not match the model's task type [{}]", RestStatus.BAD_REQUEST, new Object[]{request.getTaskType(), unparsedModel.taskType()}));
                return;
            }
            Optional service = this.serviceRegistry.getService(unparsedModel.service());
            if (service.isPresent()) {
                ((InferenceService)service.get()).stop(request.getInferenceEntityId(), l1);
            } else {
                l1.onFailure((Exception)new ElasticsearchStatusException("No service found for model " + request.getInferenceEntityId(), RestStatus.NOT_FOUND, new Object[0]));
            }
        }).andThen((l2, didStop) -> {
            if (didStop.booleanValue()) {
                this.modelRegistry.deleteModel(request.getInferenceEntityId(), (ActionListener<Boolean>)l2);
            } else {
                l2.onFailure((Exception)new ElasticsearchStatusException("Failed to stop model " + request.getInferenceEntityId(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }).addListener(listener.delegateFailure((l3, didDeleteModel) -> listener.onResponse((Object)AcknowledgedResponse.of((boolean)didDeleteModel))));
    }

    protected ClusterBlockException checkBlock(DeleteInferenceModelAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }
}

