/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.QuarterProcessor;

public class Quarter
extends BaseDateTimeFunction {
    public Quarter(Source source, Expression field, ZoneId zoneId) {
        super(source, field, zoneId);
    }

    public ScriptTemplate asScript() {
        ScriptTemplate script = super.asScript();
        String template = this.formatTemplate("{sql}.quarter(" + script.template() + ", {})");
        ParamsBuilder params = ParamsBuilder.paramsBuilder().script(script.params()).variable((Object)this.zoneId().getId());
        return new ScriptTemplate(template, params.build(), this.dataType());
    }

    @Override
    protected NodeInfo.NodeCtor2<Expression, ZoneId, BaseDateTimeFunction> ctorForInfo() {
        return Quarter::new;
    }

    protected Quarter replaceChild(Expression newChild) {
        return new Quarter(this.source(), newChild, this.zoneId());
    }

    protected Processor makeProcessor() {
        return new QuarterProcessor(this.zoneId());
    }

    public DataType dataType() {
        return DataTypes.INTEGER;
    }
}

