/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class CommunityIdProcessor
extends AbstractProcessor {
    public static final String TYPE = "community_id";
    private static final ThreadLocal<MessageDigest> MESSAGE_DIGEST = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    });
    private final String sourceIpField;
    private final String sourcePortField;
    private final String destinationIpField;
    private final String destinationPortField;
    private final String ianaNumberField;
    private final String transportField;
    private final String icmpTypeField;
    private final String icmpCodeField;
    private final String targetField;
    private final byte[] seed;
    private final boolean ignoreMissing;

    CommunityIdProcessor(String tag, String description, String sourceIpField, String sourcePortField, String destinationIpField, String destinationPortField, String ianaNumberField, String transportField, String icmpTypeField, String icmpCodeField, String targetField, byte[] seed, boolean ignoreMissing) {
        super(tag, description);
        this.sourceIpField = sourceIpField;
        this.sourcePortField = sourcePortField;
        this.destinationIpField = destinationIpField;
        this.destinationPortField = destinationPortField;
        this.ianaNumberField = ianaNumberField;
        this.transportField = transportField;
        this.icmpTypeField = icmpTypeField;
        this.icmpCodeField = icmpCodeField;
        this.targetField = targetField;
        this.seed = seed;
        this.ignoreMissing = ignoreMissing;
    }

    public String getSourceIpField() {
        return this.sourceIpField;
    }

    public String getSourcePortField() {
        return this.sourcePortField;
    }

    public String getDestinationIpField() {
        return this.destinationIpField;
    }

    public String getDestinationPortField() {
        return this.destinationPortField;
    }

    public String getIanaNumberField() {
        return this.ianaNumberField;
    }

    public String getTransportField() {
        return this.transportField;
    }

    public String getIcmpTypeField() {
        return this.icmpTypeField;
    }

    public String getIcmpCodeField() {
        return this.icmpCodeField;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public boolean getIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        Object icmpCode;
        Object icmpType;
        Supplier<Object> destinationPort;
        Supplier<Object> sourcePort;
        Supplier<Object> transport;
        Object ianaNumber;
        String destinationIp;
        String sourceIp = (String)ingestDocument.getFieldValue(this.sourceIpField, String.class, this.ignoreMissing);
        Flow flow = CommunityIdProcessor.buildFlow(sourceIp, destinationIp = (String)ingestDocument.getFieldValue(this.destinationIpField, String.class, this.ignoreMissing), ianaNumber = ingestDocument.getFieldValue(this.ianaNumberField, Object.class, true), transport = () -> ingestDocument.getFieldValue(this.transportField, Object.class, this.ignoreMissing), sourcePort = () -> ingestDocument.getFieldValue(this.sourcePortField, Object.class, this.ignoreMissing), destinationPort = () -> ingestDocument.getFieldValue(this.destinationPortField, Object.class, this.ignoreMissing), icmpType = ingestDocument.getFieldValue(this.icmpTypeField, Object.class, true), icmpCode = ingestDocument.getFieldValue(this.icmpCodeField, Object.class, true));
        if (flow == null) {
            if (this.ignoreMissing) {
                return ingestDocument;
            }
            throw new IllegalArgumentException("unable to construct flow from document");
        }
        ingestDocument.setFieldValue(this.targetField, (Object)flow.toCommunityId(this.seed));
        return ingestDocument;
    }

    public static String apply(String sourceIpAddrString, String destIpAddrString, Object ianaNumber, Object transport, Object sourcePort, Object destinationPort, Object icmpType, Object icmpCode, int seed) {
        Flow flow = CommunityIdProcessor.buildFlow(sourceIpAddrString, destIpAddrString, ianaNumber, () -> transport, () -> sourcePort, () -> destinationPort, icmpType, icmpCode);
        if (flow == null) {
            throw new IllegalArgumentException("unable to construct flow from document");
        }
        return flow.toCommunityId(CommunityIdProcessor.toUint16(seed));
    }

    public static String apply(String sourceIpAddrString, String destIpAddrString, Object ianaNumber, Object transport, Object sourcePort, Object destinationPort, Object icmpType, Object icmpCode) {
        return CommunityIdProcessor.apply(sourceIpAddrString, destIpAddrString, ianaNumber, transport, sourcePort, destinationPort, icmpType, icmpCode, 0);
    }

    private static Flow buildFlow(String sourceIpAddrString, String destIpAddrString, Object ianaNumber, Supplier<Object> transport, Supplier<Object> sourcePort, Supplier<Object> destinationPort, Object icmpType, Object icmpCode) {
        if (sourceIpAddrString == null) {
            return null;
        }
        if (destIpAddrString == null) {
            return null;
        }
        Flow flow = new Flow();
        flow.source = InetAddresses.forString((String)sourceIpAddrString);
        flow.destination = InetAddresses.forString((String)destIpAddrString);
        Object protocol = ianaNumber;
        if (protocol == null && (protocol = transport.get()) == null) {
            return null;
        }
        flow.protocol = Transport.fromObject(protocol);
        switch (flow.protocol) {
            case Tcp: 
            case Udp: 
            case Sctp: {
                flow.sourcePort = CommunityIdProcessor.parseIntFromObjectOrString(sourcePort.get(), "source port");
                if (flow.sourcePort < 1 || flow.sourcePort > 65535) {
                    throw new IllegalArgumentException("invalid source port [" + sourcePort.get() + "]");
                }
                flow.destinationPort = CommunityIdProcessor.parseIntFromObjectOrString(destinationPort.get(), "destination port");
                if (flow.destinationPort >= 1 && flow.destinationPort <= 65535) break;
                throw new IllegalArgumentException("invalid destination port [" + destinationPort.get() + "]");
            }
            case Icmp: 
            case IcmpIpV6: {
                flow.icmpType = CommunityIdProcessor.parseIntFromObjectOrString(icmpType, "icmp type");
                flow.icmpCode = CommunityIdProcessor.parseIntFromObjectOrString(icmpCode, "icmp code");
            }
        }
        return flow;
    }

    public String getType() {
        return TYPE;
    }

    static byte[] toUint16(int num) {
        if (num < 0 || num > 65535) {
            throw new IllegalStateException("number [" + num + "] must be a value between 0 and 65535");
        }
        return new byte[]{(byte)(num >> 8), (byte)num};
    }

    static int parseIntFromObjectOrString(Object o, String fieldName) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return number.intValue();
        }
        if (o instanceof String) {
            String string = (String)o;
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("unable to parse " + fieldName + " [" + o + "]");
    }

    public static final class Flow {
        private static final List<Transport> TRANSPORTS_WITH_PORTS = List.of(Transport.Tcp, Transport.Udp, Transport.Sctp, Transport.Icmp, Transport.IcmpIpV6);
        InetAddress source;
        InetAddress destination;
        Transport protocol;
        int sourcePort;
        int destinationPort;
        int icmpType;
        int icmpCode;

        boolean isOrdered() {
            int result = new BigInteger(1, this.source.getAddress()).compareTo(new BigInteger(1, this.destination.getAddress()));
            return result < 0 || result == 0 && this.sourcePort < this.destinationPort;
        }

        byte[] toBytes() {
            boolean hasPort = TRANSPORTS_WITH_PORTS.contains((Object)this.protocol);
            int len = this.source.getAddress().length + this.destination.getAddress().length + 2 + (hasPort ? 4 : 0);
            ByteBuffer bb = ByteBuffer.allocate(len);
            boolean isOneWay = false;
            if (this.protocol == Transport.Icmp || this.protocol == Transport.IcmpIpV6) {
                Integer equivalent = IcmpType.codeEquivalent(this.icmpType, this.protocol == Transport.IcmpIpV6);
                isOneWay = equivalent == null;
                this.sourcePort = this.icmpType;
                this.destinationPort = equivalent == null ? this.icmpCode : equivalent;
            }
            boolean keepOrder = this.isOrdered() || (this.protocol == Transport.Icmp || this.protocol == Transport.IcmpIpV6) && isOneWay;
            bb.put(keepOrder ? this.source.getAddress() : this.destination.getAddress());
            bb.put(keepOrder ? this.destination.getAddress() : this.source.getAddress());
            bb.put(CommunityIdProcessor.toUint16(this.protocol.getTransportNumber() << 8));
            if (hasPort) {
                bb.put(keepOrder ? CommunityIdProcessor.toUint16(this.sourcePort) : CommunityIdProcessor.toUint16(this.destinationPort));
                bb.put(keepOrder ? CommunityIdProcessor.toUint16(this.destinationPort) : CommunityIdProcessor.toUint16(this.sourcePort));
            }
            return bb.array();
        }

        String toCommunityId(byte[] seed) {
            MessageDigest md = MESSAGE_DIGEST.get();
            md.reset();
            md.update(seed);
            byte[] encodedBytes = Base64.getEncoder().encode(md.digest(this.toBytes()));
            return "1:" + new String(encodedBytes, StandardCharsets.UTF_8);
        }
    }

    public static enum Transport {
        Icmp(1),
        Igmp(2),
        Tcp(6),
        Udp(17),
        Gre(47),
        IcmpIpV6(58),
        Eigrp(88),
        Ospf(89),
        Pim(103),
        Sctp(132);

        private final int transportNumber;
        private static final Map<String, Transport> TRANSPORT_NAMES;

        private Transport(int transportNumber) {
            this.transportNumber = transportNumber;
        }

        public int getTransportNumber() {
            return this.transportNumber;
        }

        public static Transport fromNumber(int transportNumber) {
            return switch (transportNumber) {
                case 1 -> Icmp;
                case 2 -> Igmp;
                case 6 -> Tcp;
                case 17 -> Udp;
                case 47 -> Gre;
                case 58 -> IcmpIpV6;
                case 88 -> Eigrp;
                case 89 -> Ospf;
                case 103 -> Pim;
                case 132 -> Sctp;
                default -> throw new IllegalArgumentException("unknown transport protocol number [" + transportNumber + "]");
            };
        }

        public static Transport fromObject(Object o) {
            if (o instanceof Number) {
                Number number = (Number)o;
                return Transport.fromNumber(number.intValue());
            }
            if (o instanceof String) {
                String protocolStr = (String)o;
                if (TRANSPORT_NAMES.containsKey(protocolStr.toLowerCase(Locale.ROOT))) {
                    return TRANSPORT_NAMES.get(protocolStr.toLowerCase(Locale.ROOT));
                }
                try {
                    int protocolNumber = Integer.parseInt(protocolStr);
                    return Transport.fromNumber(protocolNumber);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("could not convert string [" + protocolStr + "] to transport protocol");
                }
            }
            throw new IllegalArgumentException("could not convert value of type [" + o.getClass().getName() + "] to transport protocol");
        }

        static {
            TRANSPORT_NAMES = new HashMap<String, Transport>();
            TRANSPORT_NAMES.put("icmp", Icmp);
            TRANSPORT_NAMES.put("igmp", Igmp);
            TRANSPORT_NAMES.put("tcp", Tcp);
            TRANSPORT_NAMES.put("udp", Udp);
            TRANSPORT_NAMES.put("gre", Gre);
            TRANSPORT_NAMES.put("ipv6-icmp", IcmpIpV6);
            TRANSPORT_NAMES.put("icmpv6", IcmpIpV6);
            TRANSPORT_NAMES.put("eigrp", Eigrp);
            TRANSPORT_NAMES.put("ospf", Ospf);
            TRANSPORT_NAMES.put("pim", Pim);
            TRANSPORT_NAMES.put("sctp", Sctp);
        }
    }

    public static enum IcmpType {
        EchoReply(0),
        EchoRequest(8),
        RouterAdvertisement(9),
        RouterSolicitation(10),
        TimestampRequest(13),
        TimestampReply(14),
        InfoRequest(15),
        InfoReply(16),
        AddressMaskRequest(17),
        AddressMaskReply(18),
        V6EchoRequest(128),
        V6EchoReply(129),
        V6RouterSolicitation(133),
        V6RouterAdvertisement(134),
        V6NeighborSolicitation(135),
        V6NeighborAdvertisement(136),
        V6MLDv1MulticastListenerQueryMessage(130),
        V6MLDv1MulticastListenerReportMessage(131),
        V6WhoAreYouRequest(139),
        V6WhoAreYouReply(140),
        V6HomeAddressDiscoveryRequest(144),
        V6HomeAddressDiscoveryResponse(145);

        private static final Map<Integer, Integer> ICMP_V4_CODE_EQUIVALENTS;
        private static final Map<Integer, Integer> ICMP_V6_CODE_EQUIVALENTS;
        private final int type;

        private IcmpType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static IcmpType fromNumber(int type) {
            return switch (type) {
                case 0 -> EchoReply;
                case 8 -> EchoRequest;
                case 9 -> RouterAdvertisement;
                case 10 -> RouterSolicitation;
                case 13 -> TimestampRequest;
                case 14 -> TimestampReply;
                case 15 -> InfoRequest;
                case 16 -> InfoReply;
                case 17 -> AddressMaskRequest;
                case 18 -> AddressMaskReply;
                case 128 -> V6EchoRequest;
                case 129 -> V6EchoReply;
                case 133 -> V6RouterSolicitation;
                case 134 -> V6RouterAdvertisement;
                case 135 -> V6NeighborSolicitation;
                case 136 -> V6NeighborAdvertisement;
                case 130 -> V6MLDv1MulticastListenerQueryMessage;
                case 131 -> V6MLDv1MulticastListenerReportMessage;
                case 139 -> V6WhoAreYouRequest;
                case 140 -> V6WhoAreYouReply;
                case 144 -> V6HomeAddressDiscoveryRequest;
                case 145 -> V6HomeAddressDiscoveryResponse;
                default -> EchoReply;
            };
        }

        public static Integer codeEquivalent(int icmpType, boolean isIpV6) {
            return isIpV6 ? ICMP_V6_CODE_EQUIVALENTS.get(icmpType) : ICMP_V4_CODE_EQUIVALENTS.get(icmpType);
        }

        static {
            ICMP_V4_CODE_EQUIVALENTS = new HashMap<Integer, Integer>();
            ICMP_V4_CODE_EQUIVALENTS.put(EchoRequest.getType(), EchoReply.getType());
            ICMP_V4_CODE_EQUIVALENTS.put(EchoReply.getType(), EchoRequest.getType());
            ICMP_V4_CODE_EQUIVALENTS.put(TimestampRequest.getType(), TimestampReply.getType());
            ICMP_V4_CODE_EQUIVALENTS.put(TimestampReply.getType(), TimestampRequest.getType());
            ICMP_V4_CODE_EQUIVALENTS.put(InfoRequest.getType(), InfoReply.getType());
            ICMP_V4_CODE_EQUIVALENTS.put(RouterSolicitation.getType(), RouterAdvertisement.getType());
            ICMP_V4_CODE_EQUIVALENTS.put(RouterAdvertisement.getType(), RouterSolicitation.getType());
            ICMP_V4_CODE_EQUIVALENTS.put(AddressMaskRequest.getType(), AddressMaskReply.getType());
            ICMP_V4_CODE_EQUIVALENTS.put(AddressMaskReply.getType(), AddressMaskRequest.getType());
            ICMP_V6_CODE_EQUIVALENTS = new HashMap<Integer, Integer>();
            ICMP_V6_CODE_EQUIVALENTS.put(V6EchoRequest.getType(), V6EchoReply.getType());
            ICMP_V6_CODE_EQUIVALENTS.put(V6EchoReply.getType(), V6EchoRequest.getType());
            ICMP_V6_CODE_EQUIVALENTS.put(V6RouterSolicitation.getType(), V6RouterAdvertisement.getType());
            ICMP_V6_CODE_EQUIVALENTS.put(V6RouterAdvertisement.getType(), V6RouterSolicitation.getType());
            ICMP_V6_CODE_EQUIVALENTS.put(V6NeighborAdvertisement.getType(), V6NeighborSolicitation.getType());
            ICMP_V6_CODE_EQUIVALENTS.put(V6NeighborSolicitation.getType(), V6NeighborAdvertisement.getType());
            ICMP_V6_CODE_EQUIVALENTS.put(V6MLDv1MulticastListenerQueryMessage.getType(), V6MLDv1MulticastListenerReportMessage.getType());
            ICMP_V6_CODE_EQUIVALENTS.put(V6WhoAreYouRequest.getType(), V6WhoAreYouReply.getType());
            ICMP_V6_CODE_EQUIVALENTS.put(V6WhoAreYouReply.getType(), V6WhoAreYouRequest.getType());
            ICMP_V6_CODE_EQUIVALENTS.put(V6HomeAddressDiscoveryRequest.getType(), V6HomeAddressDiscoveryResponse.getType());
            ICMP_V6_CODE_EQUIVALENTS.put(V6HomeAddressDiscoveryResponse.getType(), V6HomeAddressDiscoveryRequest.getType());
        }
    }

    public static final class Factory
    implements Processor.Factory {
        static final String DEFAULT_SOURCE_IP = "source.ip";
        static final String DEFAULT_SOURCE_PORT = "source.port";
        static final String DEFAULT_DEST_IP = "destination.ip";
        static final String DEFAULT_DEST_PORT = "destination.port";
        static final String DEFAULT_IANA_NUMBER = "network.iana_number";
        static final String DEFAULT_TRANSPORT = "network.transport";
        static final String DEFAULT_ICMP_TYPE = "icmp.type";
        static final String DEFAULT_ICMP_CODE = "icmp.code";
        static final String DEFAULT_TARGET = "network.community_id";

        public CommunityIdProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String sourceIpField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"source_ip", (String)DEFAULT_SOURCE_IP);
            String sourcePortField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"source_port", (String)DEFAULT_SOURCE_PORT);
            String destIpField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"destination_ip", (String)DEFAULT_DEST_IP);
            String destPortField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"destination_port", (String)DEFAULT_DEST_PORT);
            String ianaNumberField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"iana_number", (String)DEFAULT_IANA_NUMBER);
            String transportField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"transport", (String)DEFAULT_TRANSPORT);
            String icmpTypeField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"icmp_type", (String)DEFAULT_ICMP_TYPE);
            String icmpCodeField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"icmp_code", (String)DEFAULT_ICMP_CODE);
            String targetField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)DEFAULT_TARGET);
            int seedInt = ConfigurationUtils.readIntProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"seed", (Integer)0);
            if (seedInt < 0 || seedInt > 65535) {
                throw ConfigurationUtils.newConfigurationException((String)CommunityIdProcessor.TYPE, (String)processorTag, (String)"seed", (String)"must be a value between 0 and 65535");
            }
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)true);
            return new CommunityIdProcessor(processorTag, description, sourceIpField, sourcePortField, destIpField, destPortField, ianaNumberField, transportField, icmpTypeField, icmpCodeField, targetField, CommunityIdProcessor.toUint16(seedInt), ignoreMissing);
        }
    }
}

