/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.DestConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformDestIndexSettings;

public class PreviewTransformAction
extends ActionType<Response> {
    public static final PreviewTransformAction INSTANCE = new PreviewTransformAction();
    public static final String NAME = "cluster:admin/transform/preview";
    public static final String DUMMY_DEST_INDEX_FOR_PREVIEW = "unused-transform-preview-index";

    private PreviewTransformAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField PREVIEW = new ParseField("preview", new String[0]);
        public static final ParseField GENERATED_DEST_INDEX_SETTINGS = new ParseField("generated_dest_index", new String[0]);
        private final List<Map<String, Object>> docs;
        private final TransformDestIndexSettings generatedDestIndexSettings;

        public Response(List<Map<String, Object>> docs, TransformDestIndexSettings generatedDestIndexSettings) {
            this.docs = docs;
            this.generatedDestIndexSettings = generatedDestIndexSettings;
        }

        public Response(StreamInput in) throws IOException {
            int size = in.readInt();
            this.docs = new ArrayList<Map<String, Object>>(size);
            for (int i = 0; i < size; ++i) {
                this.docs.add(in.readGenericMap());
            }
            this.generatedDestIndexSettings = new TransformDestIndexSettings(in);
        }

        public List<Map<String, Object>> getDocs() {
            return this.docs;
        }

        public TransformDestIndexSettings getGeneratedDestIndexSettings() {
            return this.generatedDestIndexSettings;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.docs.size());
            for (Map<String, Object> doc : this.docs) {
                out.writeGenericMap(doc);
            }
            this.generatedDestIndexSettings.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(PREVIEW.getPreferredName(), this.docs);
            builder.field(GENERATED_DEST_INDEX_SETTINGS.getPreferredName(), (ToXContent)this.generatedDestIndexSettings);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(other.docs, this.docs) && Objects.equals(other.generatedDestIndexSettings, this.generatedDestIndexSettings);
        }

        public int hashCode() {
            return Objects.hash(this.docs, this.generatedDestIndexSettings);
        }

        public String toString() {
            return org.elasticsearch.common.Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private final TransformConfig config;

        public Request(TransformConfig config, TimeValue timeout) {
            super(timeout);
            this.config = config;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new TransformConfig(in);
        }

        public static Request fromXContent(XContentParser parser, TimeValue timeout) throws IOException {
            Map content = parser.map();
            HashMap<String, String> tempDestination = new HashMap<String, String>();
            tempDestination.put(DestConfig.INDEX.getPreferredName(), PreviewTransformAction.DUMMY_DEST_INDEX_FOR_PREVIEW);
            Object providedDestination = content.get(TransformField.DESTINATION.getPreferredName());
            if (providedDestination instanceof Map) {
                Map providedDestinationAsMap = (Map)providedDestination;
                tempDestination.putAll(providedDestinationAsMap);
            }
            content.put(TransformField.DESTINATION.getPreferredName(), tempDestination);
            content.putIfAbsent(TransformField.ID.getPreferredName(), "transform-preview");
            try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(content);){
                Request request;
                block13: {
                    XContentParser newParser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG.withRegistry(parser.getXContentRegistry()), (BytesReference)BytesReference.bytes((XContentBuilder)xContentBuilder), (XContentType)XContentType.JSON);
                    try {
                        request = new Request(TransformConfig.fromXContent(newParser, null, false), timeout);
                        if (newParser == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (newParser != null) {
                            try {
                                newParser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    newParser.close();
                }
                return request;
            }
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            validationException = this.config.validate(validationException);
            validationException = SourceDestValidator.validateRequest(validationException, this.config.getDestination() != null ? this.config.getDestination().getIndex() : null);
            return validationException;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.config.toXContent(builder, params);
        }

        public TransformConfig getConfig() {
            return this.config;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.config);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.config, other.config);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, Strings.format((String)"preview_transform[%s]", (Object[])new Object[]{this.config.getId()}), parentTaskId, headers);
        }
    }
}

