/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class TermsEnumResponse
extends BroadcastResponse {
    public static final String TERMS_FIELD = "terms";
    public static final String COMPLETE_FIELD = "complete";
    private final List<String> terms;
    private boolean complete;

    TermsEnumResponse(StreamInput in) throws IOException {
        super(in);
        this.terms = in.readStringCollectionAsList();
        this.complete = in.readBoolean();
    }

    public TermsEnumResponse(List<String> terms, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, boolean complete) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.terms = terms == null ? Collections.emptyList() : terms;
        this.complete = complete;
    }

    public List<String> getTerms() {
        return this.terms;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringCollection(this.terms);
        out.writeBoolean(this.complete);
    }

    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TERMS_FIELD);
        if (this.getTerms() != null && !this.getTerms().isEmpty()) {
            for (String term : this.getTerms()) {
                builder.value(term);
            }
        }
        builder.endArray();
        builder.field(COMPLETE_FIELD, this.complete);
    }
}

