/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteSnapshotLifecycleAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteSnapshotLifecycleAction INSTANCE = new DeleteSnapshotLifecycleAction();
    public static final String NAME = "cluster:admin/slm/delete";

    protected DeleteSnapshotLifecycleAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String lifecycleId;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.lifecycleId = in.readString();
        }

        public Request() {
        }

        public Request(String lifecycleId) {
            this.lifecycleId = Objects.requireNonNull(lifecycleId, "id may not be null");
        }

        public String getLifecycleId() {
            return this.lifecycleId;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.lifecycleId);
        }

        public int hashCode() {
            return this.lifecycleId.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.lifecycleId, other.lifecycleId);
        }
    }
}

