/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.user;

import java.util.List;
import java.util.Optional;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.user.ReservedUser;

public class AnonymousUser
extends ReservedUser {
    public static final String DEFAULT_ANONYMOUS_USERNAME = "_anonymous";
    public static final Setting<String> USERNAME_SETTING = new Setting(SecurityField.setting("authc.anonymous.username"), "_anonymous", s -> s, new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> ROLES_SETTING = Setting.stringListSetting((String)SecurityField.setting("authc.anonymous.roles"), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public AnonymousUser(Settings settings) {
        super((String)USERNAME_SETTING.get(settings), ((List)ROLES_SETTING.get(settings)).toArray(Strings.EMPTY_ARRAY), AnonymousUser.isAnonymousEnabled(settings), Optional.empty());
    }

    public static boolean isAnonymousEnabled(Settings settings) {
        return ROLES_SETTING.exists(settings) && !((List)ROLES_SETTING.get(settings)).isEmpty();
    }

    public static boolean isAnonymousUsername(String username, Settings settings) {
        return ((String)USERNAME_SETTING.get(settings)).equals(username) || DEFAULT_ANONYMOUS_USERNAME.equals(username);
    }

    public static void addSettings(List<Setting<?>> settingsList) {
        settingsList.add(USERNAME_SETTING);
        settingsList.add(ROLES_SETTING);
    }
}

