/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.support;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.support.SecurityQueryTemplateEvaluator;
import org.elasticsearch.xpack.core.security.user.User;

public final class DLSRoleQueryValidator {
    private DLSRoleQueryValidator() {
    }

    public static void validateQueryField(RoleDescriptor.IndicesPrivileges[] indicesPrivileges, NamedXContentRegistry xContentRegistry) {
        if (indicesPrivileges != null) {
            for (int i = 0; i < indicesPrivileges.length; ++i) {
                BytesReference query = indicesPrivileges[i].getQuery();
                try {
                    if (query == null || DLSRoleQueryValidator.isTemplateQuery(query, xContentRegistry)) continue;
                    DLSRoleQueryValidator.evaluateAndVerifyRoleQuery(query.utf8ToString(), xContentRegistry);
                    continue;
                }
                catch (IOException | IllegalArgumentException | ParsingException e) {
                    throw new ElasticsearchParseException("failed to parse field 'query' for indices [" + Strings.arrayToCommaDelimitedString((Object[])indicesPrivileges[i].getIndices()) + "] at index privilege [" + i + "] of role descriptor", e, new Object[0]);
                }
            }
        }
    }

    private static boolean isTemplateQuery(BytesReference query, NamedXContentRegistry xContentRegistry) throws IOException {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(DLSRoleQueryValidator.parserConfig(xContentRegistry), query.utf8ToString());){
            boolean bl = DLSRoleQueryValidator.isTemplateQuery(parser);
            return bl;
        }
    }

    private static boolean isTemplateQuery(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(parser.getTokenLocation(), "expected [" + XContentParser.Token.START_OBJECT + "] but found [" + token + "] instead");
        }
        token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new XContentParseException(parser.getTokenLocation(), "expected [" + XContentParser.Token.FIELD_NAME + "] with value a query name or 'template' but found [" + token + "] instead");
        }
        String fieldName = parser.currentName();
        return "template".equals(fieldName);
    }

    public static boolean hasStoredScript(BytesReference query, NamedXContentRegistry xContentRegistry) throws IOException {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(DLSRoleQueryValidator.parserConfig(xContentRegistry), query.utf8ToString());){
            if (!DLSRoleQueryValidator.isTemplateQuery(parser)) {
                boolean bl = false;
                return bl;
            }
            if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                throw new XContentParseException(parser.getTokenLocation(), "expected [" + XContentParser.Token.START_OBJECT + "] but found [" + parser.currentToken() + "] instead");
            }
            boolean bl = ScriptType.STORED == Script.parse((XContentParser)parser).getType();
            return bl;
        }
    }

    @Nullable
    public static QueryBuilder evaluateAndVerifyRoleQuery(BytesReference query, ScriptService scriptService, NamedXContentRegistry xContentRegistry, User user) {
        if (query != null) {
            String templateResult = SecurityQueryTemplateEvaluator.evaluateTemplate(query.utf8ToString(), scriptService, user);
            try {
                return DLSRoleQueryValidator.evaluateAndVerifyRoleQuery(templateResult, xContentRegistry);
            }
            catch (IOException | ElasticsearchParseException | ParsingException | XContentParseException e) {
                throw new ElasticsearchParseException("failed to parse field 'query' from the role descriptor", e, new Object[0]);
            }
        }
        return null;
    }

    @Nullable
    public static QueryBuilder evaluateAndVerifyRoleQuery(String query, final NamedXContentRegistry xContentRegistry) throws IOException {
        if (query != null) {
            NamedXContentRegistry registryWrapper = new NamedXContentRegistry(Collections.emptyList()){

                public <T, C> T parseNamedObject(Class<T> categoryClass, String name, XContentParser parser, C context) throws IOException {
                    Object namedObject = xContentRegistry.parseNamedObject(categoryClass, name, parser, context);
                    if (categoryClass.equals(QueryBuilder.class)) {
                        GeoShapeQueryBuilder geoShapeQueryBuilder;
                        if (namedObject instanceof TermsQueryBuilder) {
                            TermsQueryBuilder termsQueryBuilder = (TermsQueryBuilder)namedObject;
                            if (termsQueryBuilder.termsLookup() != null) {
                                throw new IllegalArgumentException("terms query with terms lookup isn't supported as part of a role query");
                            }
                        } else if (namedObject instanceof GeoShapeQueryBuilder && (geoShapeQueryBuilder = (GeoShapeQueryBuilder)namedObject).shape() == null) {
                            throw new IllegalArgumentException("geoshape query referring to indexed shapes isn't supported as part of a role query");
                        }
                    }
                    return (T)namedObject;
                }
            };
            try (XContentParser parser = XContentFactory.xContent((CharSequence)query).createParser(DLSRoleQueryValidator.parserConfig(registryWrapper), query);){
                QueryBuilder queryBuilder = AbstractQueryBuilder.parseTopLevelQuery((XContentParser)parser, queryName -> {
                    switch (queryName) {
                        case "percolate": 
                        case "has_child": 
                        case "has_parent": {
                            throw new IllegalArgumentException(queryName + " query isn't supported as part of a role query");
                        }
                    }
                });
                return queryBuilder;
            }
        }
        return null;
    }

    private static XContentParserConfiguration parserConfig(NamedXContentRegistry xContentRegistry) {
        return XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
    }
}

