/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.LDAPSDKUsageException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionModel;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.FieldExpression;

public interface UserRoleMapper {
    public void resolveRoles(UserData var1, ActionListener<Set<String>> var2);

    public void clearRealmCacheOnChange(CachingRealm var1);

    public static class DistinguishedNamePredicate
    implements Predicate<FieldExpression.FieldValue> {
        private final String string;
        private final DistinguishedNameNormalizer dnNormalizer;
        private final String normalizedDn;

        public DistinguishedNamePredicate(String string, DistinguishedNameNormalizer dnNormalizer) {
            assert (string != null) : "DN string should not be null. Use the dedicated NULL_PREDICATE for every user null field.";
            this.string = string;
            this.dnNormalizer = dnNormalizer;
            this.normalizedDn = dnNormalizer.normalize(string);
        }

        public String toString() {
            return this.string;
        }

        @Override
        public boolean test(FieldExpression.FieldValue fieldValue) {
            CharacterRunAutomaton automaton = fieldValue.getAutomaton();
            if (automaton != null) {
                String suffix;
                if (automaton.run(this.string)) {
                    return true;
                }
                if (this.normalizedDn != null && automaton.run(this.normalizedDn)) {
                    return true;
                }
                if (automaton.run(this.string.toLowerCase(Locale.ROOT)) || automaton.run(this.string.toUpperCase(Locale.ROOT))) {
                    return true;
                }
                if (this.normalizedDn == null) {
                    return false;
                }
                assert (fieldValue.getValue() instanceof String) : "FieldValue " + fieldValue + " has automaton but value is " + (Serializable)(fieldValue.getValue() == null ? "<null>" : fieldValue.getValue().getClass());
                String pattern = (String)fieldValue.getValue();
                if (pattern.startsWith("*,") && (suffix = pattern.substring(2)).indexOf(42) == -1) {
                    return this.isDescendantOf(this.dnNormalizer.normalize(suffix));
                }
                return false;
            }
            Object suffix = fieldValue.getValue();
            if (suffix instanceof String) {
                String testString = (String)suffix;
                if (testString.equalsIgnoreCase(this.string)) {
                    return true;
                }
                if (this.normalizedDn == null) {
                    return false;
                }
                String testNormalizedDn = this.dnNormalizer.normalize(testString);
                if (testNormalizedDn != null) {
                    return this.normalizedDn.equals(testNormalizedDn);
                }
                return testString.equalsIgnoreCase(this.normalizedDn);
            }
            return false;
        }

        private boolean isDescendantOf(String normalizedDnSuffix) {
            if (normalizedDnSuffix == null) {
                return false;
            }
            return this.normalizedDn.endsWith("," + normalizedDnSuffix) || normalizedDnSuffix.isEmpty() && false == this.normalizedDn.isEmpty();
        }
    }

    public static class DistinguishedNameNormalizer {
        private static final Logger LOGGER = LogManager.getLogger(DistinguishedNameNormalizer.class);
        private static final SoftReference<String> NULL_REF = new SoftReference<Object>(null);
        private final Map<String, SoftReference<String>> cache = new HashMap<String, SoftReference<String>>();

        public String normalize(String str) {
            String normalizedDn;
            SoftReference<String> normalizedDnRef = this.cache.get(str);
            if (normalizedDnRef == NULL_REF) {
                return null;
            }
            if (normalizedDnRef != null && (normalizedDn = normalizedDnRef.get()) != null) {
                return normalizedDn;
            }
            normalizedDn = this.doNormalize(str);
            if (normalizedDn == null) {
                this.cache.put(str, NULL_REF);
            } else {
                this.cache.put(str, new SoftReference<String>(normalizedDn));
            }
            return normalizedDn;
        }

        String doNormalize(String str) {
            DN dn;
            try {
                dn = new DN(str);
            }
            catch (LDAPException | LDAPSDKUsageException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(() -> "failed to parse [" + str + "] as a DN", e);
                }
                return null;
            }
            return dn.toNormalizedString();
        }
    }

    public static class UserData {
        private final String username;
        @Nullable
        private final String dn;
        private final Set<String> groups;
        private final Map<String, Object> metadata;
        private final RealmConfig realm;

        public UserData(String username, @Nullable String dn, Collection<String> groups, Map<String, Object> metadata, RealmConfig realm) {
            this.username = username;
            this.dn = dn;
            this.groups = Set.copyOf(groups);
            this.metadata = Map.copyOf(metadata);
            this.realm = realm;
        }

        public ExpressionModel asModel() {
            ExpressionModel model = new ExpressionModel();
            DistinguishedNameNormalizer dnNormalizer = this.getDnNormalizer();
            model.defineField("username", this.username);
            if (this.dn != null) {
                model.defineField("dn", this.dn, new DistinguishedNamePredicate(this.dn, dnNormalizer));
            }
            model.defineField("groups", this.groups, this.groups.stream().map(g -> new DistinguishedNamePredicate((String)g, dnNormalizer)).reduce(Predicate::or).orElse(Predicates.never()));
            this.metadata.keySet().forEach(k -> model.defineField("metadata." + k, this.metadata.get(k)));
            model.defineField("realm.name", this.realm.name());
            return model;
        }

        public String toString() {
            return "UserData{username:" + this.username + "; dn:" + this.dn + "; groups:" + this.groups + "; metadata:" + this.metadata + "; realm=" + this.realm.name() + "}";
        }

        public String getUsername() {
            return this.username;
        }

        @Nullable
        public String getDn() {
            return this.dn;
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public RealmConfig getRealm() {
            return this.realm;
        }

        DistinguishedNameNormalizer getDnNormalizer() {
            return new DistinguishedNameNormalizer();
        }
    }
}

