/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.RuleAction;
import org.elasticsearch.xpack.core.ml.job.config.RuleCondition;
import org.elasticsearch.xpack.core.ml.job.config.RuleScope;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DetectionRule
implements ToXContentObject,
Writeable {
    public static final ParseField DETECTION_RULE_FIELD = new ParseField("detection_rule", new String[0]);
    public static final ParseField ACTIONS_FIELD = new ParseField("actions", new String[0]);
    public static final ParseField SCOPE_FIELD = new ParseField("scope", new String[0]);
    public static final ParseField CONDITIONS_FIELD = new ParseField("conditions", new String[0]);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = DetectionRule.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = DetectionRule.createParser(false);
    private final EnumSet<RuleAction> actions;
    private final RuleScope scope;
    private final List<RuleCondition> conditions;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(DETECTION_RULE_FIELD.getPreferredName(), ignoreUnknownFields, Builder::new);
        parser.declareStringArray(Builder::setActions, ACTIONS_FIELD);
        parser.declareObject(Builder::setScope, RuleScope.parser(ignoreUnknownFields), SCOPE_FIELD);
        parser.declareObjectArray(Builder::setConditions, ignoreUnknownFields ? RuleCondition.LENIENT_PARSER : RuleCondition.STRICT_PARSER, CONDITIONS_FIELD);
        return parser;
    }

    private DetectionRule(EnumSet<RuleAction> actions, RuleScope scope, List<RuleCondition> conditions) {
        this.actions = Objects.requireNonNull(actions);
        this.scope = Objects.requireNonNull(scope);
        this.conditions = Collections.unmodifiableList(conditions);
    }

    public DetectionRule(StreamInput in) throws IOException {
        this.actions = in.readEnumSet(RuleAction.class);
        this.scope = new RuleScope(in);
        this.conditions = in.readCollectionAsList(RuleCondition::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnumSet(this.actions);
        this.scope.writeTo(out);
        out.writeCollection(this.conditions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTIONS_FIELD.getPreferredName(), this.actions);
        if (!this.scope.isEmpty()) {
            builder.field(SCOPE_FIELD.getPreferredName(), (ToXContent)this.scope);
        }
        if (!this.conditions.isEmpty()) {
            builder.field(CONDITIONS_FIELD.getPreferredName(), this.conditions);
        }
        builder.endObject();
        return builder;
    }

    public EnumSet<RuleAction> getActions() {
        return this.actions;
    }

    public RuleScope getScope() {
        return this.scope;
    }

    public List<RuleCondition> getConditions() {
        return this.conditions;
    }

    public Set<String> extractReferencedFilters() {
        return this.scope.getReferencedFilters();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DetectionRule)) {
            return false;
        }
        DetectionRule other = (DetectionRule)obj;
        return Objects.equals(this.actions, other.actions) && Objects.equals(this.scope, other.scope) && Objects.equals(this.conditions, other.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.scope, this.conditions);
    }

    public static class Builder {
        private EnumSet<RuleAction> actions = EnumSet.of(RuleAction.SKIP_RESULT);
        private RuleScope scope = new RuleScope();
        private List<RuleCondition> conditions = Collections.emptyList();

        public Builder(RuleScope.Builder scope) {
            this.scope = scope.build();
        }

        public Builder(List<RuleCondition> conditions) {
            this.conditions = ExceptionsHelper.requireNonNull(conditions, CONDITIONS_FIELD.getPreferredName());
        }

        Builder() {
        }

        public Builder setActions(List<String> actions) {
            this.actions.clear();
            actions.stream().map(RuleAction::fromString).forEach(this.actions::add);
            return this;
        }

        public Builder setActions(EnumSet<RuleAction> actions) {
            this.actions = Objects.requireNonNull(actions, ACTIONS_FIELD.getPreferredName());
            return this;
        }

        public Builder setActions(RuleAction ... actions) {
            this.actions.clear();
            Arrays.stream(actions).forEach(this.actions::add);
            return this;
        }

        public Builder setScope(RuleScope scope) {
            this.scope = Objects.requireNonNull(scope);
            return this;
        }

        public Builder setConditions(List<RuleCondition> conditions) {
            this.conditions = ExceptionsHelper.requireNonNull(conditions, CONDITIONS_FIELD.getPreferredName());
            return this;
        }

        public DetectionRule build() {
            if (this.scope.isEmpty() && this.conditions.isEmpty()) {
                String msg = Messages.getMessage("Invalid detector rule: at least scope or a condition is required");
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
            return new DetectionRule(this.actions, this.scope, this.conditions);
        }
    }
}

