/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.EmbeddingInt;
import org.elasticsearch.xpack.core.inference.results.LegacyTextEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbedding;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingUtils;
import org.elasticsearch.xpack.core.ml.inference.results.TextEmbeddingResults;

public record TextEmbeddingByteResults(List<Embedding> embeddings) implements InferenceServiceResults,
TextEmbedding
{
    public static final String NAME = "text_embedding_service_byte_results";
    public static final String TEXT_EMBEDDING_BYTES = "text_embedding_bytes";

    public TextEmbeddingByteResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(Embedding::new));
    }

    @Override
    public int getFirstEmbeddingSize() {
        return TextEmbeddingUtils.getFirstEmbeddingSize(new ArrayList<EmbeddingInt>(this.embeddings));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TEXT_EMBEDDING_BYTES);
        for (Embedding embedding : this.embeddings) {
            embedding.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    public String getWriteableName() {
        return NAME;
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.embeddings.stream().map(embedding -> embedding.values.stream().mapToDouble(value -> value.byteValue()).toArray()).map(values -> new TextEmbeddingResults(TEXT_EMBEDDING_BYTES, (double[])values, false)).toList();
    }

    public List<? extends InferenceResults> transformToLegacyFormat() {
        LegacyTextEmbeddingResults legacyEmbedding = new LegacyTextEmbeddingResults(this.embeddings.stream().map(embedding -> new LegacyTextEmbeddingResults.Embedding(embedding.toFloats())).toList());
        return List.of(legacyEmbedding);
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TEXT_EMBEDDING_BYTES, this.embeddings.stream().map(Embedding::asMap).collect(Collectors.toList()));
        return map;
    }

    public record Embedding(List<Byte> values) implements Writeable,
    ToXContentObject,
    EmbeddingInt
    {
        public static final String EMBEDDING = "embedding";

        public Embedding(StreamInput in) throws IOException {
            this(in.readCollectionAsImmutableList(StreamInput::readByte));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.values, StreamOutput::writeByte);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(EMBEDDING);
            for (Byte value : this.values) {
                builder.value(value);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public Map<String, Object> asMap() {
            return Map.of(EMBEDDING, this.values);
        }

        public List<Float> toFloats() {
            return this.values.stream().map(Byte::floatValue).toList();
        }

        @Override
        public int getSize() {
            return this.values().size();
        }
    }
}

