/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingUtils;
import org.elasticsearch.xpack.core.ml.inference.results.ChunkedTextEmbeddingResults;

public class ChunkedTextEmbeddingResults
implements ChunkedInferenceServiceResults {
    public static final String NAME = "chunked_text_embedding_service_results";
    public static final String FIELD_NAME = "text_embedding_chunk";
    private final List<ChunkedTextEmbeddingResults.EmbeddingChunk> chunks;

    public static ChunkedTextEmbeddingResults ofMlResult(org.elasticsearch.xpack.core.ml.inference.results.ChunkedTextEmbeddingResults mlInferenceResults) {
        return new ChunkedTextEmbeddingResults(mlInferenceResults.getChunks());
    }

    public static List<ChunkedInferenceServiceResults> of(List<String> inputs, TextEmbeddingResults textEmbeddings) {
        TextEmbeddingUtils.validateInputSizeAgainstEmbeddings(inputs, textEmbeddings.embeddings().size());
        ArrayList<ChunkedInferenceServiceResults> results = new ArrayList<ChunkedInferenceServiceResults>(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            results.add(ChunkedTextEmbeddingResults.of(inputs.get(i), textEmbeddings.embeddings().get(i).values()));
        }
        return results;
    }

    public static ChunkedTextEmbeddingResults of(String input, List<Float> floatEmbeddings) {
        double[] doubleEmbeddings = floatEmbeddings.stream().mapToDouble(ChunkedTextEmbeddingResults::floatToDouble).toArray();
        return new ChunkedTextEmbeddingResults(List.of(new ChunkedTextEmbeddingResults.EmbeddingChunk(input, doubleEmbeddings)));
    }

    private static double floatToDouble(Float aFloat) {
        return aFloat != null ? (double)aFloat.floatValue() : 0.0;
    }

    public ChunkedTextEmbeddingResults(List<ChunkedTextEmbeddingResults.EmbeddingChunk> chunks) {
        this.chunks = chunks;
    }

    public ChunkedTextEmbeddingResults(StreamInput in) throws IOException {
        this.chunks = in.readCollectionAsList(ChunkedTextEmbeddingResults.EmbeddingChunk::new);
    }

    public List<ChunkedTextEmbeddingResults.EmbeddingChunk> getChunks() {
        return this.chunks;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(FIELD_NAME);
        for (ChunkedTextEmbeddingResults.EmbeddingChunk embedding : this.chunks) {
            embedding.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.chunks);
    }

    public String getWriteableName() {
        return NAME;
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        throw new UnsupportedOperationException("Chunked results are not returned in the coordinated action");
    }

    public List<? extends InferenceResults> transformToLegacyFormat() {
        throw new UnsupportedOperationException("Chunked results are not returned in the legacy format");
    }

    public Map<String, Object> asMap() {
        return Map.of(FIELD_NAME, this.chunks.stream().map(ChunkedTextEmbeddingResults.EmbeddingChunk::asMap).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkedTextEmbeddingResults that = (ChunkedTextEmbeddingResults)o;
        return Objects.equals(this.chunks, that.chunks);
    }

    public int hashCode() {
        return Objects.hash(this.chunks);
    }
}

