/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.segments.IndexSegments;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequest;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ilm.AsyncWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class SegmentCountStep
extends AsyncWaitStep {
    private static final Logger logger = LogManager.getLogger(SegmentCountStep.class);
    public static final String NAME = "segment-count";
    private final int maxNumSegments;

    public SegmentCountStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, int maxNumSegments) {
        super(key, nextStepKey, client);
        this.maxNumSegments = maxNumSegments;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public int getMaxNumSegments() {
        return this.maxNumSegments;
    }

    @Override
    public void evaluateCondition(Metadata metadata, Index index, AsyncWaitStep.Listener listener, TimeValue masterTimeout) {
        this.getClient().admin().indices().segments(new IndicesSegmentsRequest(new String[]{index.getName()}), ActionListener.wrap(response -> {
            IndexSegments idxSegments = (IndexSegments)response.getIndices().get(index.getName());
            if (idxSegments == null || response.getShardFailures() != null && response.getShardFailures().length > 0) {
                DefaultShardOperationFailedException[] failures = response.getShardFailures();
                logger.info("[{}] retrieval of segment counts after force merge did not succeed, there were {} shard failures. failures: {}", (Object)index.getName(), (Object)response.getFailedShards(), (Object)(failures == null ? "n/a" : Strings.collectionToDelimitedString((Iterable)Arrays.stream(failures).map(Strings::toString).collect(Collectors.toList()), (String)",")));
                listener.onResponse(true, new Info(-1L));
            } else {
                List<ShardSegments> unmergedShards = idxSegments.getShards().values().stream().flatMap(iss -> Arrays.stream(iss.shards())).filter(shardSegments -> shardSegments.getSegments().size() > this.maxNumSegments).toList();
                if (unmergedShards.size() > 0) {
                    Map<ShardRouting, Integer> unmergedShardCounts = unmergedShards.stream().collect(Collectors.toMap(ShardSegments::getShardRouting, ss -> ss.getSegments().size()));
                    logger.info("[{}] best effort force merge to [{}] segments did not succeed for {} shards: {}", (Object)index.getName(), (Object)this.maxNumSegments, (Object)unmergedShards.size(), unmergedShardCounts);
                }
                listener.onResponse(true, new Info(unmergedShards.size()));
            }
        }, listener::onFailure));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxNumSegments);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentCountStep other = (SegmentCountStep)obj;
        return super.equals(obj) && Objects.equals(this.maxNumSegments, other.maxNumSegments);
    }

    public static class Info
    implements ToXContentObject {
        private final long numberShardsLeftToMerge;
        static final ParseField SHARDS_TO_MERGE = new ParseField("shards_left_to_merge", new String[0]);
        static final ParseField MESSAGE = new ParseField("message", new String[0]);
        static final ConstructingObjectParser<Info, Void> PARSER = new ConstructingObjectParser("segment_count_step_info", a -> new Info((Long)a[0]));

        public Info(long numberShardsLeftToMerge) {
            this.numberShardsLeftToMerge = numberShardsLeftToMerge;
        }

        public long getNumberShardsLeftToMerge() {
            return this.numberShardsLeftToMerge;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.numberShardsLeftToMerge == 0L) {
                builder.field(MESSAGE.getPreferredName(), "all shards force merged successfully");
            } else {
                builder.field(MESSAGE.getPreferredName(), "[" + this.numberShardsLeftToMerge + "] shards did not successfully force merge");
            }
            builder.field(SHARDS_TO_MERGE.getPreferredName(), this.numberShardsLeftToMerge);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.numberShardsLeftToMerge);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Info other = (Info)obj;
            return Objects.equals(this.numberShardsLeftToMerge, other.numberShardsLeftToMerge);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SHARDS_TO_MERGE);
            PARSER.declareString((i, s) -> {}, MESSAGE);
        }
    }
}

