/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;

public class OperationModeUpdateTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(OperationModeUpdateTask.class);
    @Nullable
    private final OperationMode ilmMode;
    @Nullable
    private final OperationMode slmMode;

    public static AckedClusterStateUpdateTask wrap(final OperationModeUpdateTask task, AckedRequest request, ActionListener<AcknowledgedResponse> listener) {
        return new AckedClusterStateUpdateTask(task.priority(), request, listener){

            public ClusterState execute(ClusterState currentState) {
                return task.execute(currentState);
            }
        };
    }

    private OperationModeUpdateTask(Priority priority, OperationMode ilmMode, OperationMode slmMode) {
        super(priority);
        this.ilmMode = ilmMode;
        this.slmMode = slmMode;
    }

    public static OperationModeUpdateTask ilmMode(OperationMode mode) {
        return new OperationModeUpdateTask(OperationModeUpdateTask.getPriority(mode), mode, null);
    }

    public static OperationModeUpdateTask slmMode(OperationMode mode) {
        return new OperationModeUpdateTask(OperationModeUpdateTask.getPriority(mode), null, mode);
    }

    private static Priority getPriority(OperationMode mode) {
        if (mode == OperationMode.STOPPED || mode == OperationMode.STOPPING) {
            return Priority.IMMEDIATE;
        }
        return Priority.NORMAL;
    }

    public OperationMode getILMOperationMode() {
        return this.ilmMode;
    }

    public OperationMode getSLMOperationMode() {
        return this.slmMode;
    }

    public ClusterState execute(ClusterState currentState) {
        ClusterState newState = currentState;
        newState = this.updateILMState(newState);
        newState = this.updateSLMState(newState);
        return newState;
    }

    private ClusterState updateILMState(ClusterState currentState) {
        if (this.ilmMode == null) {
            return currentState;
        }
        OperationMode currentMode = LifecycleOperationMetadata.currentILMMode(currentState);
        if (currentMode.equals((Object)this.ilmMode)) {
            return currentState;
        }
        if (!currentMode.isValidChange(this.ilmMode)) {
            return currentState;
        }
        OperationMode newMode = this.ilmMode;
        logger.info("updating ILM operation mode to {}", (Object)newMode);
        return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.metadata()).putCustom("lifecycle_operation", (Metadata.Custom)new LifecycleOperationMetadata(newMode, LifecycleOperationMetadata.currentSLMMode(currentState)))).build();
    }

    private ClusterState updateSLMState(ClusterState currentState) {
        if (this.slmMode == null) {
            return currentState;
        }
        OperationMode currentMode = LifecycleOperationMetadata.currentSLMMode(currentState);
        if (currentMode.equals((Object)this.slmMode)) {
            return currentState;
        }
        if (!currentMode.isValidChange(this.slmMode)) {
            return currentState;
        }
        OperationMode newMode = this.slmMode;
        logger.info("updating SLM operation mode to {}", (Object)newMode);
        return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.metadata()).putCustom("lifecycle_operation", (Metadata.Custom)new LifecycleOperationMetadata(LifecycleOperationMetadata.currentILMMode(currentState), newMode))).build();
    }

    public void onFailure(Exception e) {
        logger.error("unable to update lifecycle metadata with new ilm mode [" + this.ilmMode + "], slm mode [" + this.slmMode + "]", (Throwable)e);
    }

    public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
        if (this.ilmMode != null) {
            logger.info("ILM operation mode updated to {}", (Object)this.ilmMode);
        }
        if (this.slmMode != null) {
            logger.info("SLM operation mode updated to {}", (Object)this.slmMode);
        }
    }
}

