/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ccr.action.FollowParameters;

public final class PutFollowAction
extends ActionType<Response> {
    public static final PutFollowAction INSTANCE = new PutFollowAction();
    public static final String NAME = "indices:admin/xpack/ccr/put_follow";

    private PutFollowAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final boolean followIndexCreated;
        private final boolean followIndexShardsAcked;
        private final boolean indexFollowingStarted;

        public Response(boolean followIndexCreated, boolean followIndexShardsAcked, boolean indexFollowingStarted) {
            this.followIndexCreated = followIndexCreated;
            this.followIndexShardsAcked = followIndexShardsAcked;
            this.indexFollowingStarted = indexFollowingStarted;
        }

        public boolean isFollowIndexCreated() {
            return this.followIndexCreated;
        }

        public boolean isFollowIndexShardsAcked() {
            return this.followIndexShardsAcked;
        }

        public boolean isIndexFollowingStarted() {
            return this.indexFollowingStarted;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.followIndexCreated = in.readBoolean();
            this.followIndexShardsAcked = in.readBoolean();
            this.indexFollowingStarted = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.followIndexCreated);
            out.writeBoolean(this.followIndexShardsAcked);
            out.writeBoolean(this.indexFollowingStarted);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("follow_index_created", this.followIndexCreated);
            builder.field("follow_index_shards_acked", this.followIndexShardsAcked);
            builder.field("index_following_started", this.indexFollowingStarted);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.followIndexCreated == response.followIndexCreated && this.followIndexShardsAcked == response.followIndexShardsAcked && this.indexFollowingStarted == response.indexFollowingStarted;
        }

        public int hashCode() {
            return Objects.hash(this.followIndexCreated, this.followIndexShardsAcked, this.indexFollowingStarted);
        }

        public String toString() {
            return "PutFollowAction.Response{followIndexCreated=" + this.followIndexCreated + ", followIndexShardsAcked=" + this.followIndexShardsAcked + ", indexFollowingStarted=" + this.indexFollowingStarted + "}";
        }
    }

    public static final class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest,
    ToXContentObject {
        private static final ParseField REMOTE_CLUSTER_FIELD = new ParseField("remote_cluster", new String[0]);
        private static final ParseField LEADER_INDEX_FIELD = new ParseField("leader_index", new String[0]);
        private static final ParseField SETTINGS_FIELD = new ParseField("settings", new String[0]);
        private static final ParseField DATA_STREAM_NAME = new ParseField("data_stream_name", new String[0]);
        private static final ObjectParser<PutFollowParameters, Void> PARSER = new ObjectParser("indices:admin/xpack/ccr/put_follow", PutFollowParameters::new);
        private String remoteCluster;
        private String leaderIndex;
        private String followerIndex;
        @Nullable
        private String dataStreamName;
        private Settings settings = Settings.EMPTY;
        private FollowParameters parameters = new FollowParameters();
        private ActiveShardCount waitForActiveShards = ActiveShardCount.NONE;

        public static Request fromXContent(XContentParser parser) throws IOException {
            PutFollowParameters parameters = (PutFollowParameters)PARSER.parse(parser, null);
            Request request = new Request();
            request.setRemoteCluster(parameters.remoteCluster);
            request.setLeaderIndex(parameters.leaderIndex);
            request.setDataStreamName(parameters.dataStreamName);
            request.setSettings(parameters.settings);
            request.setParameters(parameters);
            return request;
        }

        public Request() {
        }

        public String getFollowerIndex() {
            return this.followerIndex;
        }

        public void setFollowerIndex(String followerIndex) {
            this.followerIndex = followerIndex;
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public void setRemoteCluster(String remoteCluster) {
            this.remoteCluster = remoteCluster;
        }

        public String getLeaderIndex() {
            return this.leaderIndex;
        }

        public void setLeaderIndex(String leaderIndex) {
            this.leaderIndex = leaderIndex;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public void setSettings(Settings settings) {
            this.settings = Objects.requireNonNull(settings);
        }

        public FollowParameters getParameters() {
            return this.parameters;
        }

        public void setParameters(FollowParameters parameters) {
            this.parameters = parameters;
        }

        @Nullable
        public String getDataStreamName() {
            return this.dataStreamName;
        }

        public void setDataStreamName(String dataStreamName) {
            this.dataStreamName = dataStreamName;
        }

        public ActiveShardCount waitForActiveShards() {
            return this.waitForActiveShards;
        }

        public void waitForActiveShards(ActiveShardCount waitForActiveShards) {
            this.waitForActiveShards = waitForActiveShards.equals((Object)ActiveShardCount.DEFAULT) ? ActiveShardCount.NONE : waitForActiveShards;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = this.parameters.validate();
            if (this.remoteCluster == null) {
                e = ValidateActions.addValidationError((String)(REMOTE_CLUSTER_FIELD.getPreferredName() + " is missing"), (ActionRequestValidationException)e);
            }
            if (this.leaderIndex == null) {
                e = ValidateActions.addValidationError((String)(LEADER_INDEX_FIELD.getPreferredName() + " is missing"), (ActionRequestValidationException)e);
            }
            if (this.followerIndex == null) {
                e = ValidateActions.addValidationError((String)"follower_index is missing", (ActionRequestValidationException)e);
            }
            if (this.dataStreamName != null && !Strings.hasText((String)this.dataStreamName)) {
                e = ValidateActions.addValidationError((String)"data stream name must contain text if present", (ActionRequestValidationException)e);
            }
            return e;
        }

        public String[] indices() {
            return new String[]{this.followerIndex};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.remoteCluster = in.readString();
            this.leaderIndex = in.readString();
            this.followerIndex = in.readString();
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_9_0)) {
                this.settings = Settings.readSettingsFromStream((StreamInput)in);
            }
            this.parameters = new FollowParameters(in);
            this.waitForActiveShards(ActiveShardCount.readFrom((StreamInput)in));
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_4_0)) {
                this.dataStreamName = in.readOptionalString();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.remoteCluster);
            out.writeString(this.leaderIndex);
            out.writeString(this.followerIndex);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_9_0)) {
                this.settings.writeTo(out);
            }
            this.parameters.writeTo(out);
            this.waitForActiveShards.writeTo(out);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_4_0)) {
                out.writeOptionalString(this.dataStreamName);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
            builder.field(LEADER_INDEX_FIELD.getPreferredName(), this.leaderIndex);
            if (this.dataStreamName != null) {
                builder.field(DATA_STREAM_NAME.getPreferredName(), this.dataStreamName);
            }
            if (!this.settings.isEmpty()) {
                builder.startObject(SETTINGS_FIELD.getPreferredName());
                this.settings.toXContent(builder, params);
                builder.endObject();
            }
            this.parameters.toXContentFragment(builder);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.remoteCluster, request.remoteCluster) && Objects.equals(this.leaderIndex, request.leaderIndex) && Objects.equals(this.followerIndex, request.followerIndex) && Objects.equals(this.parameters, request.parameters) && Objects.equals(this.waitForActiveShards, request.waitForActiveShards) && Objects.equals(this.dataStreamName, request.dataStreamName) && Objects.equals(this.settings, request.settings);
        }

        public int hashCode() {
            return Objects.hash(this.remoteCluster, this.leaderIndex, this.followerIndex, this.parameters, this.settings, this.waitForActiveShards, this.dataStreamName);
        }

        static {
            PARSER.declareString((putFollowParameters, value) -> {
                putFollowParameters.remoteCluster = value;
            }, REMOTE_CLUSTER_FIELD);
            PARSER.declareString((putFollowParameters, value) -> {
                putFollowParameters.leaderIndex = value;
            }, LEADER_INDEX_FIELD);
            PARSER.declareString((putFollowParameters, value) -> {
                putFollowParameters.dataStreamName = value;
            }, DATA_STREAM_NAME);
            PARSER.declareObject((putFollowParameters, value) -> {
                putFollowParameters.settings = value;
            }, (p, c) -> Settings.fromXContent((XContentParser)p), SETTINGS_FIELD);
            FollowParameters.initParser(PARSER);
        }

        private static class PutFollowParameters
        extends FollowParameters {
            private String remoteCluster;
            private String leaderIndex;
            private String dataStreamName;
            private Settings settings = Settings.EMPTY;

            private PutFollowParameters() {
            }
        }
    }
}

