/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ccr.AutoFollowStats;
import org.elasticsearch.xpack.core.ccr.action.FollowStatsAction;

public class CcrStatsAction
extends ActionType<Response> {
    public static final String NAME = "cluster:monitor/ccr/stats";
    public static final CcrStatsAction INSTANCE = new CcrStatsAction();

    private CcrStatsAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        private final AutoFollowStats autoFollowStats;
        private final FollowStatsAction.StatsResponses followStats;

        public Response(AutoFollowStats autoFollowStats, FollowStatsAction.StatsResponses followStats) {
            this.autoFollowStats = Objects.requireNonNull(autoFollowStats);
            this.followStats = Objects.requireNonNull(followStats);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.autoFollowStats = new AutoFollowStats(in);
            this.followStats = new FollowStatsAction.StatsResponses(in);
        }

        public AutoFollowStats getAutoFollowStats() {
            return this.autoFollowStats;
        }

        public FollowStatsAction.StatsResponses getFollowStats() {
            return this.followStats;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.autoFollowStats.writeTo(out);
            this.followStats.writeTo(out);
        }

        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            return Iterators.concat((Iterator[])new Iterator[]{Iterators.single((builder, params) -> builder.startObject().field("auto_follow_stats", (ToXContent)this.autoFollowStats, params).field("follow_stats")), this.followStats.toXContentChunked(outerParams), ChunkedToXContentHelper.endObject()});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.autoFollowStats, response.autoFollowStats) && Objects.equals((Object)this.followStats, (Object)response.followStats);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.autoFollowStats, this.followStats});
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private TimeValue timeout;

        public Request(StreamInput in) throws IOException {
            super(in);
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.CCR_STATS_API_TIMEOUT_PARAM)) {
                this.timeout = in.readOptionalTimeValue();
            }
        }

        public Request() {
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.CCR_STATS_API_TIMEOUT_PARAM)) {
                out.writeOptionalTimeValue(this.timeout);
            }
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        public void setTimeout(String timeout) {
            this.timeout = TimeValue.parseTimeValue((String)timeout, null, (String)(((Object)((Object)this)).getClass().getSimpleName() + ".timeout"));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)((Object)o);
            return Objects.equals(this.timeout, that.timeout) && Objects.equals(this.masterNodeTimeout, that.masterNodeTimeout);
        }

        public int hashCode() {
            return Objects.hash(this.timeout, this.masterNodeTimeout);
        }

        public String toString() {
            return "CcrStatsAction.Request[timeout=" + this.timeout + ", masterNodeTimeout=" + this.masterNodeTimeout + "]";
        }
    }
}

