/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.graph;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.protocol.xpack.graph.Vertex;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class Connection {
    private Vertex from;
    private Vertex to;
    private double weight;
    private long docCount;
    private static final ParseField SOURCE = new ParseField("source", new String[0]);
    private static final ParseField TARGET = new ParseField("target", new String[0]);
    private static final ParseField WEIGHT = new ParseField("weight", new String[0]);
    private static final ParseField DOC_COUNT = new ParseField("doc_count", new String[0]);

    public Connection(Vertex from, Vertex to, double weight, long docCount) {
        this.from = from;
        this.to = to;
        this.weight = weight;
        this.docCount = docCount;
    }

    public Connection(StreamInput in, Map<Vertex.VertexId, Vertex> vertices) throws IOException {
        this.from = vertices.get(new Vertex.VertexId(in.readString(), in.readString()));
        this.to = vertices.get(new Vertex.VertexId(in.readString(), in.readString()));
        this.weight = in.readDouble();
        this.docCount = in.readVLong();
    }

    Connection() {
    }

    void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.from.getField());
        out.writeString(this.from.getTerm());
        out.writeString(this.to.getField());
        out.writeString(this.to.getTerm());
        out.writeDouble(this.weight);
        out.writeVLong(this.docCount);
    }

    public ConnectionId getId() {
        return new ConnectionId(this.from.getId(), this.to.getId());
    }

    public Vertex getFrom() {
        return this.from;
    }

    public Vertex getTo() {
        return this.to;
    }

    public double getWeight() {
        return this.weight;
    }

    public long getDocCount() {
        return this.docCount;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        return this.docCount == other.docCount && this.weight == other.weight && Objects.equals(this.to, other.to) && Objects.equals(this.from, other.from);
    }

    public int hashCode() {
        return Objects.hash(this.docCount, this.weight, this.from, this.to);
    }

    void toXContent(XContentBuilder builder, ToXContent.Params params, Map<Vertex, Integer> vertexNumbers) throws IOException {
        builder.field(SOURCE.getPreferredName(), vertexNumbers.get(this.from));
        builder.field(TARGET.getPreferredName(), vertexNumbers.get(this.to));
        builder.field(WEIGHT.getPreferredName(), this.weight);
        builder.field(DOC_COUNT.getPreferredName(), this.docCount);
    }

    public static class ConnectionId {
        private final Vertex.VertexId source;
        private final Vertex.VertexId target;

        public ConnectionId(Vertex.VertexId source, Vertex.VertexId target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionId that = (ConnectionId)o;
            return Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
        }

        public int hashCode() {
            int result = this.source != null ? this.source.hashCode() : 0;
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            return result;
        }

        public Vertex.VertexId getSource() {
            return this.source;
        }

        public Vertex.VertexId getTarget() {
            return this.target;
        }

        public String toString() {
            return this.getSource() + "->" + this.getTarget();
        }
    }
}

