/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.license.GetFeatureUsageRequest;
import org.elasticsearch.license.GetFeatureUsageResponse;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetFeatureUsageAction
extends HandledTransportAction<GetFeatureUsageRequest, GetFeatureUsageResponse> {
    public static final ActionType<GetFeatureUsageResponse> TYPE = new ActionType("cluster:admin/xpack/license/feature_usage");
    private final XPackLicenseState licenseState;

    @Inject
    public TransportGetFeatureUsageAction(TransportService transportService, ActionFilters actionFilters, XPackLicenseState licenseState) {
        super(TYPE.name(), transportService, actionFilters, GetFeatureUsageRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseState = licenseState;
    }

    protected void doExecute(Task task, GetFeatureUsageRequest request, ActionListener<GetFeatureUsageResponse> listener) {
        Map<XPackLicenseState.FeatureUsage, Long> featureUsage = this.licenseState.getLastUsed();
        ArrayList<GetFeatureUsageResponse.FeatureUsageInfo> usageInfos = new ArrayList<GetFeatureUsageResponse.FeatureUsageInfo>(featureUsage.size());
        featureUsage.forEach((usage, lastUsed) -> {
            ZonedDateTime lastUsedTime = Instant.ofEpochMilli(lastUsed).atZone(ZoneOffset.UTC);
            usageInfos.add(new GetFeatureUsageResponse.FeatureUsageInfo(usage.feature().getFamily(), usage.feature().getName(), lastUsedTime, usage.contextName(), usage.feature().getMinimumOperationMode().description()));
        });
        listener.onResponse((Object)new GetFeatureUsageResponse(usageInfos));
    }
}

