/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.Clock;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseSettings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.LicensesMetadata;
import org.elasticsearch.license.SelfGeneratedLicense;
import org.elasticsearch.license.internal.TrialLicenseVersion;
import org.elasticsearch.xpack.core.XPackPlugin;

public class StartupSelfGeneratedLicenseTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(StartupSelfGeneratedLicenseTask.class);
    static final String TASK_SOURCE = "maybe generate license for cluster";
    private int selfGeneratedLicenseMaxNodes = 1000;
    private final Settings settings;
    private final Clock clock;
    private final ClusterService clusterService;

    public StartupSelfGeneratedLicenseTask(Settings settings, Clock clock, ClusterService clusterService) {
        this.settings = settings;
        this.clock = clock;
        this.clusterService = clusterService;
    }

    public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
        LicensesMetadata licensesMetadata = (LicensesMetadata)newState.metadata().custom("licenses");
        if (logger.isDebugEnabled()) {
            logger.debug("registered self generated license: {}", (Object)licensesMetadata);
        }
    }

    public ClusterState execute(ClusterState currentState) throws Exception {
        XPackPlugin.checkReadyForXPackCustomMetadata(currentState);
        Metadata metadata = currentState.metadata();
        LicensesMetadata currentLicensesMetadata = (LicensesMetadata)metadata.custom("licenses");
        if (currentLicensesMetadata == null) {
            License.LicenseType type = SelfGeneratedLicense.validateSelfGeneratedType((License.LicenseType)((Object)LicenseSettings.SELF_GENERATED_LICENSE_TYPE.get(this.settings)));
            return this.updateWithLicense(currentState, type);
        }
        if (LicenseUtils.signatureNeedsUpdate(currentLicensesMetadata.getLicense())) {
            return this.updateLicenseSignature(currentState, currentLicensesMetadata);
        }
        if (LicenseUtils.licenseNeedsExtended(currentLicensesMetadata.getLicense())) {
            return this.extendBasic(currentState, currentLicensesMetadata);
        }
        return currentState;
    }

    private ClusterState updateLicenseSignature(ClusterState currentState, LicensesMetadata currentLicenseMetadata) {
        License license = currentLicenseMetadata.getLicense();
        Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.metadata());
        String type = license.type();
        long issueDate = license.issueDate();
        long expiryDate = LicenseUtils.getExpiryDate(license);
        if (License.LicenseType.isBasic(type) && expiryDate != LicenseSettings.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS) {
            expiryDate = LicenseSettings.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS;
        }
        License.Builder specBuilder = License.builder().uid(license.uid()).issuedTo(license.issuedTo()).maxNodes(this.selfGeneratedLicenseMaxNodes).issueDate(issueDate).type(type).expiryDate(expiryDate);
        License selfGeneratedLicense = SelfGeneratedLicense.create(specBuilder);
        TrialLicenseVersion trialVersion = currentLicenseMetadata.getMostRecentTrialVersion();
        LicensesMetadata newLicenseMetadata = new LicensesMetadata(selfGeneratedLicense, trialVersion);
        mdBuilder.putCustom("licenses", (Metadata.Custom)newLicenseMetadata);
        logger.info("Updating existing license to the new version.\n\nOld license:\n {}\n\n New license:\n{}", (Object)license, (Object)newLicenseMetadata.getLicense());
        return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
    }

    public void onFailure(@Nullable Exception e) {
        logger.error(() -> "unexpected failure during [maybe generate license for cluster]", (Throwable)e);
    }

    private ClusterState extendBasic(ClusterState currentState, LicensesMetadata currentLicenseMetadata) {
        License license = currentLicenseMetadata.getLicense();
        Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.metadata());
        LicensesMetadata newLicenseMetadata = this.createBasicLicenseFromExistingLicense(currentLicenseMetadata);
        mdBuilder.putCustom("licenses", (Metadata.Custom)newLicenseMetadata);
        logger.info("Existing basic license has an expiration. Basic licenses no longer expire.Regenerating license.\n\nOld license:\n {}\n\n New license:\n{}", (Object)license, (Object)newLicenseMetadata.getLicense());
        return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
    }

    private LicensesMetadata createBasicLicenseFromExistingLicense(LicensesMetadata currentLicenseMetadata) {
        License currentLicense = currentLicenseMetadata.getLicense();
        License.Builder specBuilder = License.builder().uid(currentLicense.uid()).issuedTo(currentLicense.issuedTo()).maxNodes(this.selfGeneratedLicenseMaxNodes).issueDate(currentLicense.issueDate()).type(License.LicenseType.BASIC).expiryDate(LicenseSettings.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS);
        License selfGeneratedLicense = SelfGeneratedLicense.create(specBuilder, currentLicense.version());
        TrialLicenseVersion trialVersion = currentLicenseMetadata.getMostRecentTrialVersion();
        return new LicensesMetadata(selfGeneratedLicense, trialVersion);
    }

    private ClusterState updateWithLicense(ClusterState currentState, License.LicenseType type) {
        long issueDate = this.clock.millis();
        Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.metadata());
        long expiryDate = type == License.LicenseType.BASIC ? LicenseSettings.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS : issueDate + LicenseSettings.NON_BASIC_SELF_GENERATED_LICENSE_DURATION.getMillis();
        License.Builder specBuilder = License.builder().uid(UUID.randomUUID().toString()).issuedTo(this.clusterService.getClusterName().value()).maxNodes(this.selfGeneratedLicenseMaxNodes).issueDate(issueDate).type(type).expiryDate(expiryDate);
        License selfGeneratedLicense = SelfGeneratedLicense.create(specBuilder);
        LicensesMetadata licensesMetadata = License.LicenseType.TRIAL.equals((Object)type) ? new LicensesMetadata(selfGeneratedLicense, TrialLicenseVersion.CURRENT) : new LicensesMetadata(selfGeneratedLicense, null);
        mdBuilder.putCustom("licenses", (Metadata.Custom)licensesMetadata);
        return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
    }
}

