/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.apmdata;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.xpack.apmdata.APMIndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class ResourceUtils {
    public static final String APM_TEMPLATE_VERSION_VARIABLE = "xpack.apmdata.template.version";

    static byte[] loadVersionedResourceUTF8(String name, int version) {
        return ResourceUtils.loadVersionedResourceUTF8(name, version, Map.of());
    }

    static byte[] loadVersionedResourceUTF8(String name, int version, Map<String, String> variables) {
        try {
            String content = ResourceUtils.loadResource(name);
            content = TemplateUtils.replaceVariables((String)content, (String)String.valueOf(version), (String)APM_TEMPLATE_VERSION_VARIABLE, variables);
            return content.getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String loadResource(String name) throws IOException {
        InputStream is = APMIndexTemplateRegistry.class.getResourceAsStream(name);
        if (is == null) {
            throw new IOException("Resource [" + name + "] not found in classpath.");
        }
        return Streams.readFully((InputStream)is).utf8ToString();
    }
}

