/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.apmdata;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.yaml.YamlXContent;
import org.elasticsearch.xpack.apmdata.ResourceUtils;
import org.elasticsearch.xpack.apmdata.YamlIngestPipelineConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.IngestPipelineConfig;

public class APMIndexTemplateRegistry
extends IndexTemplateRegistry {
    private static final Logger logger = LogManager.getLogger(APMIndexTemplateRegistry.class);
    private final int version;
    private final Map<String, ComponentTemplate> componentTemplates;
    private final Map<String, ComposableIndexTemplate> composableIndexTemplates;
    private final List<IngestPipelineConfig> ingestPipelines;
    private volatile boolean enabled;

    public APMIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        try {
            Map apmResources = XContentHelper.convertToMap((XContent)YamlXContent.yamlXContent, (String)ResourceUtils.loadResource("/resources.yaml"), (boolean)false);
            this.version = ((Number)apmResources.get("version")).intValue();
            List componentTemplateNames = (List)apmResources.get("component-templates");
            List indexTemplateNames = (List)apmResources.get("index-templates");
            List ingestPipelineConfigs = (List)apmResources.get("ingest-pipelines");
            this.componentTemplates = componentTemplateNames.stream().map(o -> (String)o).collect(Collectors.toMap(name -> name, name -> APMIndexTemplateRegistry.loadComponentTemplate(name, this.version)));
            this.composableIndexTemplates = indexTemplateNames.stream().map(o -> (String)o).collect(Collectors.toMap(name -> name, name -> APMIndexTemplateRegistry.loadIndexTemplate(name, this.version)));
            this.ingestPipelines = ingestPipelineConfigs.stream().map(o -> (Map)o).map(map -> {
                Map.Entry pipelineConfig = map.entrySet().iterator().next();
                return APMIndexTemplateRegistry.loadIngestPipeline((String)pipelineConfig.getKey(), this.version, (List)((Map)pipelineConfig.getValue()).get("dependencies"));
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getVersion() {
        return this.version;
    }

    void setEnabled(boolean enabled) {
        logger.info("APM index template registry is {}", (Object)(enabled ? "enabled" : "disabled"));
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void close() {
        this.clusterService.removeListener((ClusterStateListener)this);
    }

    protected String getOrigin() {
        return "apm";
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    protected Map<String, ComponentTemplate> getComponentTemplateConfigs() {
        if (this.enabled) {
            return this.componentTemplates;
        }
        return Map.of();
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        if (this.enabled) {
            return this.composableIndexTemplates;
        }
        return Map.of();
    }

    protected List<IngestPipelineConfig> getIngestPipelines() {
        if (this.enabled) {
            return this.ingestPipelines;
        }
        return Collections.emptyList();
    }

    private static ComponentTemplate loadComponentTemplate(String name, int version) {
        ComponentTemplate componentTemplate;
        block8: {
            byte[] content = ResourceUtils.loadVersionedResourceUTF8("/component-templates/" + name + ".yaml", version);
            XContentParser parser = YamlXContent.yamlXContent.createParser(XContentParserConfiguration.EMPTY, content);
            try {
                componentTemplate = ComponentTemplate.parse((XContentParser)parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("failed to load APM Ingest plugin's component template: " + name, e);
                }
            }
            parser.close();
        }
        return componentTemplate;
    }

    private static ComposableIndexTemplate loadIndexTemplate(String name, int version) {
        ComposableIndexTemplate composableIndexTemplate;
        block8: {
            byte[] content = ResourceUtils.loadVersionedResourceUTF8("/index-templates/" + name + ".yaml", version);
            XContentParser parser = YamlXContent.yamlXContent.createParser(XContentParserConfiguration.EMPTY, content);
            try {
                composableIndexTemplate = ComposableIndexTemplate.parse((XContentParser)parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("failed to load APM Ingest plugin's index template: " + name, e);
                }
            }
            parser.close();
        }
        return composableIndexTemplate;
    }

    private static IngestPipelineConfig loadIngestPipeline(String name, int version, @Nullable List<String> dependencies) {
        if (dependencies == null) {
            dependencies = Collections.emptyList();
        }
        return new YamlIngestPipelineConfig(name, "/ingest-pipelines/" + name + ".yaml", version, "xpack.apmdata.template.version", dependencies);
    }

    protected boolean applyRolloverAfterTemplateV2Upgrade() {
        return true;
    }
}

