/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.packageloader.action;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

final class ModelLoaderUtils {
    public static String METADATA_FILE_EXTENSION = ".metadata.json";
    public static String MODEL_FILE_EXTENSION = ".pt";
    private static ByteSizeValue VOCABULARY_SIZE_LIMIT = new ByteSizeValue(20L, ByteSizeUnit.MB);
    private static final String VOCABULARY = "vocabulary";
    private static final String MERGES = "merges";
    private static final String SCORES = "scores";

    static InputStream getInputStreamFromModelRepository(URI uri) throws IOException {
        String scheme;
        switch (scheme = uri.getScheme().toLowerCase(Locale.ROOT)) {
            case "http": 
            case "https": {
                return ModelLoaderUtils.getHttpOrHttpsInputStream(uri);
            }
            case "file": {
                return ModelLoaderUtils.getFileInputStream(uri);
            }
        }
        throw new IllegalArgumentException("unsupported scheme");
    }

    static VocabularyParts loadVocabulary(URI uri) {
        if (uri.getPath().endsWith(".json")) {
            VocabularyParts vocabularyParts;
            block9: {
                InputStream vocabInputStream = ModelLoaderUtils.getInputStreamFromModelRepository(uri);
                try {
                    vocabularyParts = ModelLoaderUtils.parseVocabParts(vocabInputStream);
                    if (vocabInputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (vocabInputStream != null) {
                            try {
                                vocabInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new ElasticsearchException("Failed to load vocabulary file", (Throwable)e, new Object[0]);
                    }
                }
                vocabInputStream.close();
            }
            return vocabularyParts;
        }
        throw new IllegalArgumentException("unknown format vocabulary file format");
    }

    static VocabularyParts parseVocabParts(InputStream vocabInputStream) throws IOException {
        Map vocabParts;
        try (XContentParser sourceParser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, Streams.limitStream((InputStream)vocabInputStream, (long)VOCABULARY_SIZE_LIMIT.getBytes()));){
            vocabParts = sourceParser.map(HashMap::new, XContentParser::list);
        }
        List<String> vocabulary = vocabParts.containsKey(VOCABULARY) ? ((List)vocabParts.get(VOCABULARY)).stream().map(Object::toString).collect(Collectors.toList()) : List.of();
        List<String> merges = vocabParts.containsKey(MERGES) ? ((List)vocabParts.get(MERGES)).stream().map(Object::toString).collect(Collectors.toList()) : List.of();
        List<Double> scores = vocabParts.containsKey(SCORES) ? ((List)vocabParts.get(SCORES)).stream().map(o -> (Double)o).collect(Collectors.toList()) : List.of();
        return new VocabularyParts(vocabulary, merges, scores);
    }

    static URI resolvePackageLocation(String repository, String artefact) throws URISyntaxException {
        URI baseUri = new URI((String)(repository.endsWith("/") ? repository : repository + "/")).normalize();
        URI resolvedUri = baseUri.resolve(artefact).normalize();
        if (Strings.isNullOrEmpty((String)baseUri.getScheme())) {
            throw new IllegalArgumentException("Repository must contain a scheme");
        }
        if (!baseUri.getScheme().equals(resolvedUri.getScheme())) {
            throw new IllegalArgumentException("Illegal schema change in package location");
        }
        if (!resolvedUri.getPath().startsWith(baseUri.getPath())) {
            throw new IllegalArgumentException("Illegal path in package location");
        }
        return baseUri.resolve(artefact);
    }

    private ModelLoaderUtils() {
    }

    @SuppressForbidden(reason="we need socket connection to download")
    private static InputStream getHttpOrHttpsInputStream(URI uri) throws IOException {
        assert (uri.getUserInfo() == null) : "URI's with credentials are not supported";
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        PrivilegedAction<InputStream> privilegedHttpReader = () -> {
            try {
                HttpURLConnection conn = (HttpURLConnection)uri.toURL().openConnection();
                switch (conn.getResponseCode()) {
                    case 200: {
                        return conn.getInputStream();
                    }
                    case 301: 
                    case 302: 
                    case 303: {
                        throw new IllegalStateException("redirects aren't supported yet");
                    }
                    case 404: {
                        throw new ResourceNotFoundException("{} not found", new Object[]{uri});
                    }
                }
                int responseCode = conn.getResponseCode();
                throw new ElasticsearchStatusException("error during downloading {}", RestStatus.fromCode((int)responseCode), new Object[]{uri});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return AccessController.doPrivileged(privilegedHttpReader);
    }

    @SuppressForbidden(reason="we need load model data from a file")
    private static InputStream getFileInputStream(URI uri) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        PrivilegedAction<InputStream> privilegedFileReader = () -> {
            File file = new File(uri);
            if (!file.exists()) {
                throw new ResourceNotFoundException("{} not found", new Object[]{uri});
            }
            try {
                return Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return AccessController.doPrivileged(privilegedFileReader);
    }

    record VocabularyParts(List<String> vocab, List<String> merges, List<Double> scores) {
    }

    static class InputStreamChunker {
        private final InputStream inputStream;
        private final MessageDigest digestSha256 = MessageDigests.sha256();
        private final int chunkSize;
        private int totalBytesRead = 0;

        InputStreamChunker(InputStream inputStream, int chunkSize) {
            this.inputStream = inputStream;
            this.chunkSize = chunkSize;
        }

        public BytesArray next() throws IOException {
            int bytesRead;
            int read;
            byte[] buf = new byte[this.chunkSize];
            for (bytesRead = 0; bytesRead < this.chunkSize && (read = this.inputStream.read(buf, bytesRead, this.chunkSize - bytesRead)) != -1; bytesRead += read) {
            }
            this.digestSha256.update(buf, 0, bytesRead);
            this.totalBytesRead += bytesRead;
            return new BytesArray(buf, 0, bytesRead);
        }

        public String getSha256() {
            return MessageDigests.toHexString((byte[])this.digestSha256.digest());
        }

        public int getTotalBytesRead() {
            return this.totalBytesRead;
        }
    }
}

