/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.packageloader;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.Build;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.Strings;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.xpack.core.ml.packageloader.action.GetTrainedModelPackageConfigAction;
import org.elasticsearch.xpack.core.ml.packageloader.action.LoadTrainedModelPackageAction;
import org.elasticsearch.xpack.ml.packageloader.action.TransportGetTrainedModelPackageConfigAction;
import org.elasticsearch.xpack.ml.packageloader.action.TransportLoadTrainedModelPackage;

public class MachineLearningPackageLoader
extends Plugin
implements ActionPlugin {
    public static final String DEFAULT_ML_MODELS_REPOSITORY = "https://ml-models.elastic.co";
    public static final Setting<String> MODEL_REPOSITORY = Setting.simpleString((String)"xpack.ml.model_repository", (String)"https://ml-models.elastic.co", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final String UTILITY_THREAD_POOL_NAME = "ml_utility";
    private static final String MODEL_REPOSITORY_DOCUMENTATION_LINK = Strings.format((String)"https://www.elastic.co/guide/en/machine-learning/%s/ml-nlp-elser.html#air-gapped-install", (Object[])new Object[]{Build.current().version().replaceFirst("^(\\d+\\.\\d+).*", "$1")});

    public List<Setting<?>> getSettings() {
        return List.of(MODEL_REPOSITORY);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)GetTrainedModelPackageConfigAction.INSTANCE, TransportGetTrainedModelPackageConfigAction.class), new ActionPlugin.ActionHandler((ActionType)LoadTrainedModelPackageAction.INSTANCE, TransportLoadTrainedModelPackage.class));
    }

    public List<BootstrapCheck> getBootstrapChecks() {
        return List.of(new BootstrapCheck(){

            public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
                try {
                    MachineLearningPackageLoader.validateModelRepository((String)MODEL_REPOSITORY.get(context.settings()), context.environment().configFile());
                }
                catch (Exception e) {
                    return BootstrapCheck.BootstrapCheckResult.failure((String)("Found an invalid configuration for xpack.ml.model_repository. " + e.getMessage() + ". See " + MODEL_REPOSITORY_DOCUMENTATION_LINK + " for more information."));
                }
                return BootstrapCheck.BootstrapCheckResult.success();
            }

            public boolean alwaysEnforce() {
                return true;
            }

            public ReferenceDocs referenceDocs() {
                return ReferenceDocs.BOOTSTRAP_CHECKS;
            }
        });
    }

    static void validateModelRepository(String repository, Path configPath) throws URISyntaxException {
        URI baseUri = new URI((String)(repository.endsWith("/") ? repository : repository + "/")).normalize();
        URI normalizedConfigUri = configPath.toUri().normalize();
        if (org.elasticsearch.common.Strings.isNullOrEmpty((String)baseUri.getScheme())) {
            throw new IllegalArgumentException("xpack.ml.model_repository must contain a scheme, supported schemes are \"http\", \"https\", \"file\"");
        }
        String scheme = baseUri.getScheme().toLowerCase(Locale.ROOT);
        if (!Set.of("http", "https", "file").contains(scheme)) {
            throw new IllegalArgumentException("xpack.ml.model_repository must be configured with one of the following schemes: \"http\", \"https\", \"file\"");
        }
        if (scheme.equals("file") && !baseUri.getPath().startsWith(normalizedConfigUri.getPath())) {
            throw new IllegalArgumentException("If xpack.ml.model_repository is a file location, it must be placed below the configuration: " + normalizedConfigUri);
        }
        if (baseUri.getUserInfo() != null) {
            throw new IllegalArgumentException("xpack.ml.model_repository does not support authentication");
        }
    }
}

