/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.transport;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.textstructure.action.AbstractFindStructureRequest;
import org.elasticsearch.xpack.core.textstructure.action.FindMessageStructureAction;
import org.elasticsearch.xpack.core.textstructure.action.FindStructureResponse;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinderManager;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;

public class TransportFindMessageStructureAction
extends HandledTransportAction<FindMessageStructureAction.Request, FindStructureResponse> {
    private final ThreadPool threadPool;

    @Inject
    public TransportFindMessageStructureAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool) {
        super("cluster:monitor/text_structure/find_message_structure", transportService, actionFilters, FindMessageStructureAction.Request::new, (Executor)threadPool.generic());
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, FindMessageStructureAction.Request request, ActionListener<FindStructureResponse> listener) {
        try {
            listener.onResponse((Object)this.buildTextStructureResponse(request));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private FindStructureResponse buildTextStructureResponse(FindMessageStructureAction.Request request) throws Exception {
        TextStructureFinderManager structureFinderManager = new TextStructureFinderManager(this.threadPool.scheduler());
        TextStructureFinder textStructureFinder = structureFinderManager.findTextStructure(request.getMessages(), new TextStructureOverrides((AbstractFindStructureRequest)request), request.getTimeout());
        return new FindStructureResponse(textStructureFinder.getStructure());
    }
}

